//Função de notificações

function notification(text, type, time = 2000) {
  Swal.fire({
    position: "right",
    icon: type,
    title: text,
    showConfirmButton: false,
    timer: time,
  });
}

function alertNotification(title, message, type, position) {
  if (position === "") {
    position = "right";
  }
  toastr[type](message, title, {
    closeButton: true,
    progressBar: true,
    positionClass: "toast-top-" + position,
    preventDuplicates: false,
    onclick: null,
    showDuration: "300",
    hideDuration: "1000",
    timeOut: "5000",
    extendedTimeOut: "1000",
    showEasing: "swing",
    hideEasing: "linear",
    showMethod: "fadeIn",
    hideMethod: "fadeOut",
  });
}

function spinner(tm) {
  return (
    '<span class="spinner-border spinner-border-' +
    tm +
    '" role="status" aria-hidden="true"></span>'
  );
}

// //FUNÇÃO DE LISTAGEM DE DADOS
function setListData(colspan, url, divView) {
  if (divView === "") {
    divView = "listDataAll";
  }
  var div = $(".table").find("." + divView);
  $.ajax({
    url: url_js + url,
    type: "post",
    beforeSend: function () {
      div.html(
        '<tr class="text-center"><td colspan="' +
          colspan +
          '">' +
          spinner("sm") +
          "</td></tr>"
      );
    },
    success: function (data) {
      div.html(data);
    },
  });
}

function openModal(title, url) {
  document.getElementById("exampleModalLabel").innerHTML = title;
  //document.getElementById('conteudoModal').innerHTML =  loading('sm');
  var myModal = new bootstrap.Modal(document.getElementById("exampleModal"), {
    keyboard: false,
    backdrop: "static",
  });
  myModal.show();

  $.ajax({
    url: url_js + url,
    type: "POST",
    beforeSend: function () {
      document.getElementById("conteudoModal").innerHTML =
        '<div class="text-center">' + spinner("sm") + "</div>";
    },
    success: function (data) {
      document.getElementById("conteudoModal").innerHTML = data;
    },
  });
}

//Fechar Modal

function closeModal() {
  var myModalEl = document.getElementById("exampleModal");
  var modal = bootstrap.Modal.getInstance(myModalEl); // Returns a Bootstrap modal instance
  modal.hide();
}


function redirect(url){
  if(url == ""){
    window.location.href = url_js;
  }else{
    window.location.href = url_js+url;
  }
}
