$("#price_produto").mask('000.000.000.000.000,00', {reverse: true});
setListData(5, "produtos/getListProdutos", 'listDataAll');

const imgProduto = document.getElementById('imgProduto');

imgProduto.addEventListener('change', event => {
    const reader = new FileReader;
    const imgView = document.getElementById('image-produto-view');
    const preview = document.getElementById('preview-image');
    if(preview){
        preview.remove();
    }
    reader.onload = function(event){
        const previewImage = document.createElement('img');
        previewImage.width = 200;
        previewImage.id = 'preview-image';
        previewImage.src = event.target.result;
        imgView.insertAdjacentElement('afterend', previewImage);
    }
    reader.readAsDataURL(imgProduto.files[0]);

})


const formAddProduto = document.getElementById('form_add_produto');

formAddProduto.addEventListener('submit', async (event) => {
    event.preventDefault();

    const formData = new FormData(formAddProduto);

    const data = await fetch(url_js+'produtos/actionAdd',{
        method: 'POST',
        body: formData
    })

    const response = await data.json();

    //console.log(response);

    if(response.msg === "erroEmpty"){
        alertNotification("ATENÇÃO!!!", "Preecnha todos os campos", "warning", "right")
    }else if(response.msg === "erroAdd"){
        alertNotification("ATENÇÃO!!!", "Erro ao tentar salvar produto, tente novamente", "danger", "right")
    }else if(response.msg === "erroTipoImg"){
        alertNotification("ATENÇÃO!!!", "Tipo de imagem não permetida", "info", "right")
    }else{
        alertNotification("SUCESSO!!!", "Produto cadastrado com sucesso", "success", "right")
    }
})
