function checkFormPag(type){
    $(this).classList.add('active-btn-pag');
}

setListData(5, "produtos/listProdutoPdv", "tbodyGetList");

//Função de adicionar produtos no PDV
const selectProd = document.getElementById('selectProduto');

selectProd.addEventListener('change', async () => {
    const data = await fetch(url_js+"produtos/getListByIdProdutos/"+selectProd.value);
    const response = await data.json();

    const valoruniProduto   = document.getElementById('valoruniProduto');
    const valorTotalProduto = document.getElementById('valorTotalProduto');
    if(selectProd.value != ""){
        valoruniProduto.disabled = false;
        valorTotalProduto.disabled = false;
        document.getElementById('qtdItensProduto').disabled = false;
        valoruniProduto.value = response.data.valor;
        valorTotalProduto.value = response.data.valor;
    }
    
})


const qtdItensProduto = document.getElementById('qtdItensProduto');
qtdItensProduto.addEventListener('change', () => {
    if(qtdItensProduto.value < 1){
        qtdItensProduto.value = 1;
    }

    const valoruniProduto   = document.getElementById('valoruniProduto');
    const valorTotalProduto = document.getElementById('valorTotalProduto');
    if(valoruniProduto.value != ""){
        const valorTotalMult = parseInt(valoruniProduto.value * qtdItensProduto.value);
        valorTotalProduto.value = valorTotalMult.toFixed(2);
    }
})

const btnSubmitAddProdList = document.getElementById('btnSubmitAddProdList');

btnSubmitAddProdList.addEventListener('click', async () => {
    const valorUniProduto   = document.getElementById('valoruniProduto');
    const qtdItensProduto   = document.getElementById('qtdItensProduto');
    const selectProd        = document.getElementById('selectProduto');

    const tbodyGetList      = document.getElementById('tbodyGetList');

    if(selectProd.value === 0 || selectProd.value === ""){
        alertNotification("ATENÇÃO!!!", "Selecione um item para adicionar a lista de produtos", "warning", "right")
    }else{
        $.ajax({
            url: url_js+'produtos/listProdutoPdv',
            type: "POST",
            data: {idProd : selectProd.value, qtdItens : qtdItensProduto.value},

            success:function(data){
                setListData(5, "produtos/listProdutoPdv", "tbodyGetList");
                alertNotification("SUCESSO!!!", "Item adicionado a lista de produtos", "success", "right");
                qtdItensProduto.disabled = true;
                valorUniProduto.disabled = true;
                document.getElementById('valorTotalProduto').disabled = true;

                qtdItensProduto.value = 1;
                valorUniProduto.value = "";
                document.getElementById('valorTotalProduto').value = "";

                document.getElementById('selectProduto').value = "";
            }
        })
    }

})


function deleteItemListVendas(idItem){
    if(confirm("Deseja remover o otem da lista de produtos?")){
        $.ajax({
            url: url_js+'produtos/deleteItemListVendas/'+idItem,
            success:function(data){
                if(data === "sucesso"){
                    //alertNotification("EXCLUIDO!!!", "Produto removido da lista", "sucesso", "right");
                    setListData(5, "produtos/listProdutoPdv", "tbodyGetList");
                }else{
                    alertNotification("ATENÇÃO!!!", "Erro item não encontrado", "warning", "right");
                    //setListData(5, "produtos/listProdutoPdv", "tbodyGetList");
                }                
            }
        })
        
    }

}

function btnAddClientePdv(idCliente, nameCliente){
    document.getElementById('buscaClienteVenda').value = nameCliente;
    document.getElementById('idClientePdvAdd').value = idCliente;
    closeModal();
}

function submitCancelarVenda(){
    openModal("Confirma senha de Operador", "pedidos/formConfirmPassword");
}

async function formSubmitVerifyPassword(){
    const form = document.getElementById('formConfirmPassword');

    const formData = new FormData(form);

    const data = await fetch(url_js+'pedidos/verifyPasswordOpr', {
        method: "POST",
        body: formData
    });

    const response = await data.json();

    //console.log(response.msg)

    if(response.msg === "sucesso"){
        cancelarVenda();
    }else if(response.msg === "erroPasswordNotConfirm"){
        alertNotification("ATENÇÃO!!!", "Sua confirmação de senha não conferi com a senha do Operador", "warning", "right");
    }else if(response.msg === "erroEmpty"){
        alertNotification("ATENÇÃO!!!", "Informe sua senha de operador", "warning", "right");
    }   
} 

function cancelarVenda(){
    $.ajax({
        url: url_js+'produtos/cancelarvendas',
        success:function(data){
            console.log(data);
            if(data === "sucesso"){
                notification("Venda cancelada com sucesso", "success", 1500)
                setListData(5, "produtos/listProdutoPdv", "tbodyGetList");
                document.getElementById('selectProduto').value = "";
                setTimeout(() => {
                    closeModal();
                }, 1000);
            }else if(data === "erro"){
                alertNotification("ATENÇÃO!!!", "Erro ao tentar cancelar venda, tente novamente", "warning", "right");
            }     
        }
    })
}



function btnOpenModalFinalizarVenda(){
    openModal("Finalizar Venda", "pedidos/formFinalizarVenda");
}

function typeFormVendas(){
    const typeFormVenda     = document.getElementById('typeFormVenda');

    const typePag       = document.getElementById('typeFormPg');    
    const valorPago     = document.getElementById('valorPago');
    if(typeFormVenda.value != ""){
        valorPago.disabled = false;
        typePag.disabled = false;
    }else{
        valorPago.disabled = true;
        typePag.disabled = true;

        valorPago.value = "";
        typePag.value = "";
    }
}


//function typeFormPg(){
function fecharVenda(){
    
    const val = document.getElementById('typeFormPg');
    const infoCliente = document.getElementById('infoCliente');
    const valorTroco = document.getElementById('valorTroco');

    const valueTotal    = document.getElementById('valorTotalInput');
    const valorPago     = document.getElementById('valorPago');
    const inforMesas     = document.getElementById('inforMesas');
    

    
        if(val.value === "Prazo"){
            infoCliente.disabled = false;
            valorTroco.value = "";
            valorTroco.disabled = true;
            valorPago.value = "";
            valorPago.disabled = true;
            inforMesas.disabled = false;
        }else if(val.value === "Dinheiro"){
            valorTroco.disabled = false;
            infoCliente.disabled = true;
            valorPago.disabled = false;
            inforMesas.disabled = true;
            if(valorPago.value != ""){
                let calTroco = valorPago.value - valueTotal.value;
                valorTroco.value = calTroco.toFixed(2)
            }
            
        }else{
            infoCliente.disabled = true;
            valorTroco.disabled = true;
            valorTroco.value = "";
            valorPago.disabled = false;
            inforMesas.disabled = true;
        }
}

function contentMesas(){
    const inforMesas = document.getElementById('inforMesas');
    const infoCliente = document.getElementById('infoCliente');
    const name_cliente = document.getElementById('name_cliente');
    if(inforMesas.value != ""){
        infoCliente.disabled = true;
        name_cliente.disabled = false;
    }else{
        infoCliente.disabled = false;
        name_cliente.disabled = true;
    }
}

function contentGetCliente(){
    const inforMesas = document.getElementById('inforMesas');
    const infoCliente = document.getElementById('infoCliente');
    if(infoCliente.value != ""){
        inforMesas.disabled = true;
    }else{
        inforMesas.disabled = false;
    }
}


function calcTroco(){
    const typePag       = document.getElementById('typeFormPg');
    const valueTotal    = document.getElementById('valorTotalInput');
    const valorPago     = document.getElementById('valorPago');
    const valorTroco    = document.getElementById('valorTroco');
    if(typePag.value === "Dinheiro"){
        if(valorPago.value != ""){
            let calTroco = valorPago.value - valueTotal.value;
            valorTroco.value = calTroco.toFixed(2)
        }else{
            valorTroco.value = "";
        }
    }
}



function addVenda(){
    const typePag       = document.getElementById('typeFormPg');    
    const valorPago     = document.getElementById('valorPago');
    const cliente       = document.getElementById('infoCliente');
    const valorTroco    = document.getElementById('valorTroco');
    const inforMesas    = document.getElementById('inforMesas');

    const typeFormVenda     = document.getElementById('typeFormVenda');

    if(typeFormVenda.value != ""){

        //Verifica se foi seleciona uma forma de pagamento
        if(typePag.value === ""){
            notification("Selecione uma forma de Pagamento", "warning", 3000);
            return;
        }else{
            //Verifica o tipo de pagamento selecionado
            if(typePag.value === "Prazo"){
                //Verifica se o cliente foi selecionado
                if(cliente.hasAttribute('disabled')){
                    //Verifica se valor pago foi informado
                    if(inforMesas.value == ""){
                        notification("Para vendas a prazo selecione um Mesa", "info", 3000);
                        return;
                    }
                }
                if(inforMesas.hasAttribute('disabled')){
                    //Verifica se valor pago foi informado
                    if(cliente.value == ""){
                        notification("Para vendas a prazo selecione um Cliente", "info", 3000);
                        return;
                    }                
                }
            }else if(typePag.value === "Dinheiro"){
                //Verifica se valor pago foi informado
                if(valorPago.value === ""){
                    notification("Informe o valor pago pelo cliente", "info", 3000);
                    return;
                }
            }else if(typePag.value === "Pix"){
                //Verifica se valor pago foi informado
                if(valorPago.value === ""){
                    notification("Informe o valor pago pelo cliente", "info", 3000);
                    return;
                }
            }else if(typePag.value === "Cartão"){
                //Verifica se valor pago foi informado
                if(valorPago.value === ""){
                    notification("Informe o valor pago pelo cliente", "info", 3000);
                    return;
                }
            }        
        }
    }else{
        notification("Selecione um tipo de venda", "info", 3000);
        return;
    }

    createVenda();

} 


function createVenda(){
    const typePag       = document.getElementById('typeFormPg');
    const cliente       = document.getElementById('infoCliente');
    const valorPago     = document.getElementById('valorPago');
    const valorTroco    = document.getElementById('valorTroco');
    const inforMesas    = document.getElementById('inforMesas');
    const name_cliente  = document.getElementById('name_cliente');

    alert(inforMesas.value);
    
    //notification("Sucesso, venda efetuada com sucesso", "success", 3000);
}

