<?php
session_start();
require 'environment.php';
date_default_timezone_set('America/Sao_Paulo');
global $config;
$config = array();

//Configuração de banco de dados
$tipo_conexao = $_SERVER['HTTP_HOST'];
if(($tipo_conexao == 'localhost') || ($tipo_conexao == '127.0.0.1')) {
	$config['dbname'] = 'flux_delivery';
	$config['host']   = 'localhost';
	$config['dbuser'] = 'root';
	$config['dbpass'] = '';
	$linkUrl = "http://";
} else {
	$config['dbname'] = 'flux_delivery';
	$config['host']   = 'localhost';
	$config['dbuser'] = 'root';
	$config['dbpass'] = '';
	$linkUrl = "https://";
}

//Função BASE URL
$pastainterna = "delivery_novo/clientedemo/novopdv/";
define("BASE_URL", "$linkUrl{$_SERVER['HTTP_HOST']}/{$pastainterna}");

/*
CONFIGURAÇÕES DE PASTAS DA DASHBOARD
*/

//Variavel de pasta de CSS
define("DIRCSS", BASE_URL."assets/css/");
//Variavel de pasta de javascript
define("DIRJS", BASE_URL."assets/js/");
//Variavel de pasta de imagens
define("DIRIMG", BASE_URL."assets/img/");
//Variavel de pasta vendor
define("DIRVENDOR", BASE_URL."assets/plugins/");
//Constante das pastas de upload
define("DIRIMGUP", "../img/");


//Função de limitar caracteres em textos grandes
function limita_caracteres($texto, $limite, $quebra = true){
	$tamanho = strlen($texto);
	if($tamanho <= $limite){ //Verifica se o tamanho do texto é menor ou igual ao limite
	   $novo_texto = $texto;
	}else{ // Se o tamanho do texto for maior que o limite
	   if($quebra == true){ // Verifica a opção de quebrar o texto
		  $novo_texto = trim(substr($texto, 0, $limite))."...";
	   }else{ // Se não, corta $texto na última palavra antes do limite
		  $ultimo_espaco = strrpos(substr($texto, 0, $limite), " "); // Localiza o útlimo espaço antes de $limite
		  $novo_texto = trim(substr($texto, 0, $ultimo_espaco))."..."; // Corta o $texto até a posição localizada
	   }
	}
	return $novo_texto; // Retorna o valor formatado
 }

//FUNÇÃO DE FORMATA MOEDA
function formatamoeda($valor){
	return number_format((float)$valor, 2, ',', '.');
}

//Função de criptografar senhas hash 
function cripPassword($password){
	return password_hash($password, PASSWORD_DEFAULT);
}

//Funçãod e formata datas formato Brasil
function formatadata($date){
	return date("d/m/Y", strtotime($date));
}

//Funçãod e formata data e hora formato Brasil
function formatadatahora($date){
	$date = explode(" ", $date);
	$data = date("d/m/Y", strtotime($date[0]));
	$hora = date("H:i:s", strtotime($date[1]));
	return $data." às ".$hora;
}


?>