<?php
class mesasController extends controller {

    public function __construct() {
        parent::__construct();

        $u = new Users();
        if($u->isLogged() == false) {
        	header("Location: ".BASE_URL."login");
        	exit;
        }
    }

    public function index() {
        $data = array(
            "nameArq" => "mesas",
            "namePag" => "Mesas",
            "textPag" => "",
        );
        $u = new Users();
        $u->setLogged();
        $ms = new Mesas;

        $data['name_user'] = $u->getUserName();

        $data['dataMesas'] = $ms->getListMesas($u->getIdCompany());

        $this->loadTemplate('mesas', $data);
    }



    public function formAddMesa(){ ?>
        <form name="formAddMesa" id="formAddMesa" method="POST">
            <div class="row">

                <div class="col-sm-12">
                    <label class="label">Número da mesa</label>
                    <input type="number" name="numero_mesa" class="form-control">
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitAddMesa()">Salvar</button>
                </div>

            </div>
        </form>
    <?php
    }

    public function add(){
        $u = new Users();
        $u->setLogged();
        $ms = new Mesas;
        $numero_mesa    = filter_input(INPUT_POST, 'numero_mesa');
        $data = array();
        if(!empty($numero_mesa)){
            if($ms->add($u->getIdCompany(), $numero_mesa) === true){
                $data['msg'] = "sucesso";
            }else{
                $data['msg'] = "erroAdd";
            }
        }else{
            $data['msg'] = "erroEmpty";
        }

        echo json_encode($data);
    }

    public function formEditMesa($idMesa){
        $u = new Users();
        $u->setLogged();
        $ms = new Mesas;
        $dataMesa = $ms->getDatMesaById($u->getIdCompany(), $idMesa);
        ?>
        <form name="formEditMesa" id="formEditMesa" method="POST">
            <div class="row">

                <div class="col-sm-12">
                    <label class="label">Número da mesa</label>
                    <input type="number" value="<?php echo $dataMesa['numero']; ?>" name="numero_mesa" class="form-control">
                    <input type="hidden" value="<?php echo $dataMesa['id']; ?>" name="id_mesa">
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitEditMesa()">Salvar</button>
                </div>

            </div>
        </form>
    <?php
    }

    public function edit(){
        $u = new Users();
        $u->setLogged();
        $ms = new Mesas;
        $numero_mesa    = filter_input(INPUT_POST, 'numero_mesa');
        $id_mesa        = filter_input(INPUT_POST, 'id_mesa');
        $data = array();
        if(!empty($numero_mesa)){
            if($ms->edit($u->getIdCompany(), $id_mesa, $numero_mesa) === true){
                $data['msg'] = "sucesso";
            }else{
                $data['msg'] = "erroAdd";
            }
        }else{
            $data['msg'] = "erroEmpty";
        }

        echo json_encode($data);
    }

    public function getListMesas(){
        $u = new Users();
        $u->setLogged();
        $ms = new Mesas;

        if(!empty($ms->getListMesas($u->getIdCompany()))){

            foreach($ms->getListMesas($u->getIdCompany()) as $dataMesa): ?>
                <tr>
                    <td>MESA - <?php echo $dataMesa['numero'] < 10 ? "0".$dataMesa['numero'] : $dataMesa['numero']; ?></td>
                    <td>
                        <button onclick="openModal('Editar Mesa', 'mesas/formEditMesa/<?php echo $dataMesa['id']; ?>')" class="btn btn-success btn-sm" title="Editar Mesa" style="color: white;">
                            <i class="fa-regular fa-pen-to-square"></i>
                        </button>

                        <button onclick='excluir(<?php echo $dataMesa["id"]; ?>)' class="btn btn-danger btn-sm" title="Excluir Produto" style="color: white;">
                            <i class="fa-solid fa-trash-can"></i>
                        </button>
                    </td>
                </tr>
            <?php endforeach;
        }else{
            echo '<tr class="text-center"><td colspan="2">Nenhuma mesa registrada</td><tr>';
        }
    }


    

}




