<?php
class opcionaisController extends controller
{

    public function __construct()
    {
        parent::__construct();

        $u = new Users();
        if ($u->isLogged() == false) {
            header("Location: " . BASE_URL . "login");
            exit;
        }
    }

    public function index()
    {
        $data = array(
            "nameArq" => "opcionais",
            "namePag" => "Opcionais",
            "textPag" => "",
        );
        $u = new Users();
        $u->setLogged();

        $data['name_user'] = $u->getUserName();

        $this->loadTemplate('opcionais', $data);
    }


    public function getListOpcionais()
    {
        $u = new Users();
        $u->setLogged();
        //$u->getIdCompany();

        $op = new Opcionais();
        if (!empty($op->getListOpcionais($u->getIdCompany()))) {
            foreach ($op->getListOpcionais($u->getIdCompany()) as $dataOpcionais) :

                $idGroup = $dataOpcionais['Id'];
                switch ($dataOpcionais['obrigatorio']) {
                    case '1':
                        $obg = "Seleção do item obrigatória (Uma opção)";
                        break;
                    case '2':
                        $obg = "Seleção do item por quantidade máxima";
                        break;
                    case '3':
                        $obg = "Sabores - 2 ou mais sabores";
                        break;
                }
?>

                <tr>
                    <td><?php echo $dataOpcionais['nomegrupo']; ?></td>
                    <td><?php echo $dataOpcionais['nomeinterno']; ?></td>
                    <td><?php echo $dataOpcionais['quantidade']; ?></td>
                    <td><?php echo $obg; ?></td>
                    <td><?php echo $dataOpcionais['posicao']; ?></td>
                    <td><span class="badges bg-<?php echo $dataOpcionais['status'] === 1 ? "lightgreen" : "lightgred"; ?>"><?php echo $dataOpcionais['status'] === 1 ? "Ativo" : "Inativo"; ?></span></td>
                    <td class="text-center"><button onclick="openModal('Adicionar Opcionais', 'opcionais/formAdicionarOpcionais/<?php echo $idGroup; ?>')" class="btn btn-warning btn-sm" title="Cadastro de Opcionais"><i class="fa-solid fa-plus"></i></button></td>
                    <td>
                        <button onclick="openModal('Editar de Grupos Opcionais', 'opcionais/formEditOpcionais/<?php echo $dataOpcionais['Id']; ?>')" class="btn btn-success btn-sm" title="Editar Produto" style="color: white;">
                            <i class="fa-regular fa-pen-to-square"></i>
                        </button>

                        <button onclick='excluir(<?php echo $dataOpcionais["Id"]; ?>)' class="btn btn-danger btn-sm" title="Excluir Produto" style="color: white;">
                            <i class="fa-solid fa-trash-can"></i>
                        </button>
                    </td>
                </tr>

        <?php
            endforeach;
        } else {
            echo '<tr class="text-center text-danger"><td colspan="6">Nenhum grupo opcional registrado</td></tr>';
        }
    }

    public function formAddOpcionais()
    { ?>

        <form name="formAddOpcionais" id="FormAddOpcionais" method="POST">
            <div class="row">
                <div class="col-sm-6">
                    <label>Nome Interno <span style="color: red;">*</span></label>
                    <input type="text" name="nome_interno" class="form-control">
                </div>

                <div class="col-sm-6">
                    <label>Nome Externo <span style="color: red;">*</span></label>
                    <input type="text" name="nome_externo" class="form-control">
                </div>

                <div class="col-sm-4">
                    <label class="label">Posição <span style="color: red;">*</span></label>
                    <input type="number" name="posicao" class="form-control">
                </div>

                <div class="col-sm-4">
                    <label class="label">Máximo de Seleção <span style="color: red;">*</span></label>
                    <input type="number" name="maximo_selecao" class="form-control">
                </div>

                <div class="col-sm-4">
                    <label class="label">Opções do Grupo <span style="color: red;">*</span></label>
                    <select class="form-control" name="cam_opcoes" required="">
                        <option value="0" disabled="" selected="">Selecione...</option>
                        <option value="1">Seleção do item obrigatória (Uma opção)</option>
                        <option value="2">Seleção do item por quantidade máxima</option>
                        <option value="3">Sabores - 2 ou mais sabores</option>
                    </select>
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitAdd()">Salvar</button>
                </div>
            </div>
        </form>

    <?php }

    public function formEditOpcionais($idOpcional)
    {
        $u = new Users();
        $u->setLogged();
        //$u->getIdCompany();

        $op = new Opcionais;
        $dataOpcional = $op->getOpcionalById($u->getIdCompany(), $idOpcional);
    ?>

        <form name="FormEditOpcionais" id="FormEditOpcionais" method="POST">
            <div class="row">
                <div class="col-sm-6">
                    <label>Nome Interno <span style="color: red;">*</span></label>
                    <input type="text" name="nome_interno" value="<?php echo $dataOpcional['nomegrupo']; ?>" class="form-control">
                    <input type="hidden" name="id_opcional" value="<?php echo $dataOpcional['Id']; ?>">
                </div>

                <div class="col-sm-6">
                    <label>Nome Externo <span style="color: red;">*</span></label>
                    <input type="text" name="nome_externo" value="<?php echo $dataOpcional['nomeinterno']; ?>" class="form-control">
                </div>

                <div class="col-sm-2">
                    <label class="label">Posição <span style="color: red;">*</span></label>
                    <input type="number" name="posicao" value="<?php echo $dataOpcional['posicao']; ?>" class="form-control">
                </div>

                <div class="col-sm-4">
                    <label class="label">Máximo de Seleção <span style="color: red;">*</span></label>
                    <input type="number" name="maximo_selecao" value="<?php echo $dataOpcional['quantidade']; ?>" class="form-control">
                </div>

                <div class="col-sm-6">
                    <label class="label">Opções do Grupo <span style="color: red;">*</span></label>
                    <select class="form-control" name="cam_opcoes" required="">
                        <option value="0" disabled="" selected="">Selecione...</option>
                        <option value="1" <?php echo $dataOpcional['obrigatorio'] === 1 ? "selected" : ""; ?>>Seleção do item obrigatória (Uma opção)</option>
                        <option value="2" <?php echo $dataOpcional['obrigatorio'] === 2 ? "selected" : ""; ?>>Seleção do item por quantidade máxima</option>
                        <option value="3" <?php echo $dataOpcional['obrigatorio'] === 3 ? "selected" : ""; ?>>Sabores - 2 ou mais sabores</option>
                    </select>
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitEdit()">Salvar</button>
                </div>
            </div>
        </form>

    <?php }


    public function add()
    {
        $data = array("msg");
        $nome_interno           = filter_input(INPUT_POST, 'nome_interno');
        $nome_externo           = filter_input(INPUT_POST, 'nome_externo');
        $posicao                = filter_input(INPUT_POST, 'posicao');
        $maximo_selecao         = filter_input(INPUT_POST, 'maximo_selecao');
        $cam_opcoes             = filter_input(INPUT_POST, 'cam_opcoes');

        $u = new Users();
        $u->setLogged();
        //$u->getIdCompany();

        if (empty($nome_interno) || empty($nome_externo) || empty($posicao) || empty($maximo_selecao) || empty($cam_opcoes)) {
            $data['msg'] = "erroEmpty";
        } else {
            $op = new Opcionais;
            if ($op->add($u->getIdCompany(), $nome_interno, $nome_externo, $posicao, $maximo_selecao, $cam_opcoes) === true) {
                $data['msg'] = "sucesso";
            } else {
                $data['msg'] = "erroAdd";
            }
        }

        echo json_encode($data);
    }

    public function excluir($id)
    {

        $op = new Opcionais;
        $data = array("msg");
        if ($op->excluir($id)) {
            $data['msg'] = "sucesso";
        } else {
            $data["msg"] = "erroDel";
        }
        echo json_encode($data);
    }

    public function edit()
    {
        $data = array("msg");
        $id_opcional           = filter_input(INPUT_POST, 'id_opcional');
        $nome_interno           = filter_input(INPUT_POST, 'nome_interno');
        $nome_externo           = filter_input(INPUT_POST, 'nome_externo');
        $posicao                = filter_input(INPUT_POST, 'posicao');
        $maximo_selecao         = filter_input(INPUT_POST, 'maximo_selecao');
        $cam_opcoes             = filter_input(INPUT_POST, 'cam_opcoes');

        $u = new Users();
        $u->setLogged();
        //$u->getIdCompany();

        if (empty($nome_interno) || empty($nome_externo) || empty($posicao) || empty($maximo_selecao) || empty($cam_opcoes)) {
            $data['msg'] = "erroEmpty";
        } else {
            $op = new Opcionais;
            if ($op->edit($u->getIdCompany(), $id_opcional, $nome_interno, $nome_externo, $posicao, $maximo_selecao, $cam_opcoes) === true) {
                $data['msg'] = "sucesso";
            } else {
                $data['msg'] = "erroAdd";
            }
        }

        echo json_encode($data);
    }


    public function formAdicionarOpcionais($idGroup)
    {
        $op = new Opcionais;
        $u = new Users();
        $u->setLogged();
        //$u->getIdCompany();
    ?>

        </script>
        <form name="formAdicionarOpcionais" id="formAdicionarOpcionais" method="POST">
            <div class="row">
                <div class="col-sm-12">
                    <label>Nome Opcional<span style="color: red;">*</span></label>
                    <input type="text" name="nome_opcional" class="form-control">
                    <input type="hidden" name="idGroup" value="<?php echo $idGroup; ?>">
                </div>

                <div class="col-sm-9">
                    <label class="label">Descrição<span style="color: red;">*</span> </label>
                    <input type="text" name="descricao" value="N" class="form-control">
                    <p style="color: red; font-size:12px;">Atenção: Deixe N se não tiver descrição.</p>
                </div>

                <div class="col-sm-3">
                    <label class="label">Valor <span style="color: red;">*</span></label>
                    <input type="number" name="valor" class="form-control">
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-secondary' onclick="formSubmitAddOpcionais()">Adicionar</button>
                </div>
            </div>
        </form>

        <div class="col-sm-12" style="margin-top: 2%">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Descrição</th>
                            <th>Valor</th>
                            <th class="text-center">Status</th>
                            <th width="100" class="text-center">Ação</th>
                        </tr>
                    </thead>
                    <tbody id="listDataAllOpcional">

                        <?php if ($op->getListOpcionaisGroup($idGroup, $u->getIdCompany())) {
                            foreach ($op->getListOpcionaisGroup($idGroup, $u->getIdCompany()) as $dataOp) :
                        ?>
                                <tr id="<?php echo $dataOp['id']; ?>">
                                    <td><?php echo $dataOp['opnome']; ?></td>
                                    <td><?php echo $dataOp['opdescricao']; ?></td>
                                    <td>R$ <?php echo formatamoeda($dataOp['valor']); ?></td>

                                    <td class="text-center" width="100"><span class="badges bg-<?php echo $dataOp['status'] == 1 ? "lightgreen" : "lightred"; ?>"><?php echo $dataOp['status'] == 1 ? "Ativo" : "Inativo"; ?></span></td>
                                    <td class="text-center" width="100">
                                        <button onclick="excluirOpcionaal(<?php echo $dataOp['id']; ?>)" class="btn btn-danger btn-sm" title="Excluir Produto" style="color: white;">
                                            <i class="fa-solid fa-trash-can"></i>
                                        </button>
                                    </td>
                                </tr>

                        <?php
                            endforeach;
                        } else {
                            echo '<tr class="text-cemter"><td colspan="5">Nenhum opção adicional registrada</td></tr>';
                        } ?>

                    </tbody>
                </table>
            </div>
        </div>
<?php }

    public function addOpcionais()
    {

        $data = array("msg");

        $nome_opcional          = filter_input(INPUT_POST, 'nome_opcional');
        $idGrupo                = filter_input(INPUT_POST, 'idGroup');
        $descricao              = filter_input(INPUT_POST, 'descricao');
        $valor                  = filter_input(INPUT_POST, 'valor');

        $u = new Users();
        $u->setLogged();
        //$u->getIdCompany();


        if (empty($nome_opcional) || empty($idGrupo) || empty($descricao) || empty($valor)) {
            $data['msg'] = "erroEmpty";
        } else {
            $opAdd = new Opcionais;
            if ($opAdd->addOpcionais($u->getIdCompany(), $idGrupo, $nome_opcional, $descricao, $valor) === true) {
                $data['msg'] = "sucesso";
            } else {
                $data['msg'] = "erroAdd";
            }
        }

        echo json_encode($data);
    }

    public function excluirOpcional($idAdicional){
        $op = new Opcionais;

        $data = array();

        if($op->excluirAdicionall($idAdicional) === true){
            $data['msg'] = "sucesso";
        }else{
            $data['msg'] = "erroDel";
        }

        echo json_encode($data);
    }
}
