<?php

class Cliente extends model{

    public function getListAllCliente($idCompany){
        $sql= $this->db->prepare("SELECT * FROM clientes WHERE idu = :idu");
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            return $sql->fetchAll();
        }else{
            return "";
        }
    }


    public function getByIdCliente($idCompany, $idCliente){
        $array = array();

        $sql = $this->db->prepare("SELECT * FROM clientes WHERE id_cliente = :id_cliente AND idu = :idu");
        $sql->bindValue(":id_cliente", $idCliente);
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            $array = $sql->fetch();
        }
        return $array;
    }


    public function add(
        $idu,
        $nome_cliente,
        $email_cliente,
        $cpf_cliente,
        $cel_cliente,
        $limite_cliente,
        $status_cliente,
        $cep_cliente,
        $endereco_cliente,
        $numero_cliente,
        $bairro_cliente,
        $cidade_cliente,
        $estado_cliente){
        $sql = $this->db->prepare("INSERT INTO clientes SET
            idu                     = :idu,
            nome_cliente            = :nome_cliente,
            email_cliente           = :email_cliente,
            cpf_cliente             = :cpf_cliente,
            cel_cliente             = :cel_cliente,
            limite_credito          = :limite_credito,
            status_cliente          = :status_cliente,
            cep_cliente             = :cep_cliente,
            endereco_cliente        = :endereco_cliente,
            numero_cliente          = :numero_cliente,
            id_bairro               = :id_bairro,
            cidade_cliente          = :cidade_cliente,
            estado_cliente          = :estado_cliente,
            data_criated            = NOW()
        ");
        $sql->bindValue(":idu", $idu);
        $sql->bindValue(":nome_cliente", $nome_cliente);
        $sql->bindValue(":email_cliente", $email_cliente);
        $sql->bindValue(":cpf_cliente", $cpf_cliente);
        $sql->bindValue(":cel_cliente", $cel_cliente);
        $sql->bindValue(":limite_credito", $limite_cliente);
        $sql->bindValue(":status_cliente", $status_cliente);
        $sql->bindValue(":cep_cliente", $cep_cliente);
        $sql->bindValue(":endereco_cliente", $endereco_cliente);
        $sql->bindValue(":numero_cliente", $numero_cliente);
        $sql->bindValue(":id_bairro", $bairro_cliente);
        $sql->bindValue(":cidade_cliente", $cidade_cliente);
        $sql->bindValue(":estado_cliente", $estado_cliente);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }


    public function edit(
        $idu,
        $id_cliente,
        $nome_cliente,
        $email_cliente,
        $cpf_cliente,
        $cel_cliente,
        $limite_cliente,
        $status_cliente,
        $cep_cliente,
        $endereco_cliente,
        $numero_cliente,
        $bairro_cliente,
        $cidade_cliente,
        $estado_cliente){
        $sql = $this->db->prepare("UPDATE clientes SET
            idu                     = :idu,
            nome_cliente            = :nome_cliente,
            email_cliente           = :email_cliente,
            cpf_cliente             = :cpf_cliente,
            cel_cliente             = :cel_cliente,
            limite_credito          = :limite_credito,
            status_cliente          = :status_cliente,
            cep_cliente             = :cep_cliente,
            endereco_cliente        = :endereco_cliente,
            numero_cliente          = :numero_cliente,
            id_bairro               = :id_bairro,
            cidade_cliente          = :cidade_cliente,
            estado_cliente          = :estado_cliente
            WHERE id_cliente        = :id_cliente
        ");
        $sql->bindValue(":idu", $idu);
        $sql->bindValue(":nome_cliente", $nome_cliente);
        $sql->bindValue(":email_cliente", $email_cliente);
        $sql->bindValue(":cpf_cliente", $cpf_cliente);
        $sql->bindValue(":cel_cliente", $cel_cliente);
        $sql->bindValue(":limite_credito", $limite_cliente);
        $sql->bindValue(":status_cliente", $status_cliente);
        $sql->bindValue(":cep_cliente", $cep_cliente);
        $sql->bindValue(":endereco_cliente", $endereco_cliente);
        $sql->bindValue(":numero_cliente", $numero_cliente);
        $sql->bindValue(":id_bairro", $bairro_cliente);
        $sql->bindValue(":cidade_cliente", $cidade_cliente);
        $sql->bindValue(":estado_cliente", $estado_cliente);
        $sql->bindValue(":id_cliente", $id_cliente);
        $sql->execute();
        return true;
    }

    public function excluir($id_cliente){
        $sql = $this->db->prepare("DELETE FROM clientes WHERE id_cliente = :id_cliente");
        $sql->bindValue(":id_cliente", $id_cliente);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }
}