<?php

class Opcionais extends model{
    public function getListOpcionais($idCompany){
        $sql = $this->db->prepare("SELECT * FROM grupos WHERE idu = :idu");
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            return $sql->fetchAll();
        }else{
            return array();
        }
    }


    public function add($idCompany, $nome_interno, $nome_externo, $posicao, $maximo_selecao, $cam_opcoes){
        $sql = $this->db->prepare("INSERT INTO grupos SET
            idu             = :idu,
            nomegrupo       = :nomegrupo,
            nomeinterno     = :nomeinterno,
            obrigatorio     = :obrigatorio,
            posicao         = :posicao,
            status          = :status,
            quantidade      = :quantidade
        ");
        $sql->bindValue(":idu", $idCompany);
        $sql->bindValue(":nomegrupo", $nome_interno);
        $sql->bindValue(":nomeinterno", $nome_externo);
        $sql->bindValue(":obrigatorio", $cam_opcoes);
        $sql->bindValue(":posicao", $posicao);
        $sql->bindValue(":status", 1);
        $sql->bindValue(":quantidade", $maximo_selecao);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }

    public function excluir($id){
        $sql = $this->db->prepare("DELETE FROM grupos WHERE Id = :id");
        $sql->bindValue(":id", $id);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }


    public function getOpcionalById($idCompany, $idOpcional){
        $sql = $this->db->prepare("SELECT * FROM grupos WHERE idu = :idu AND Id = :idGrupo");
        $sql->bindValue(":idu", $idCompany);
        $sql->bindValue(":idGrupo", $idOpcional);
        $sql->execute();
        if($sql->rowCount()>0){
            return $sql->fetch();
        }else{
            return array();
        }
    }


    public function edit($idCompany, $id_opcional, $nome_interno, $nome_externo, $posicao, $maximo_selecao, $cam_opcoes){
        $sql = $this->db->prepare("UPDATE grupos SET
            idu             = :idu,
            nomegrupo       = :nomegrupo,
            nomeinterno     = :nomeinterno,
            obrigatorio     = :obrigatorio,
            posicao         = :posicao,
            status          = :status,
            quantidade      = :quantidade
            WHERE Id = :id_opcional
        ");
        $sql->bindValue(":id_opcional", $id_opcional);
        $sql->bindValue(":idu", $idCompany);
        $sql->bindValue(":nomegrupo", $nome_interno);
        $sql->bindValue(":nomeinterno", $nome_externo);
        $sql->bindValue(":obrigatorio", $cam_opcoes);
        $sql->bindValue(":posicao", $posicao);
        $sql->bindValue(":status", 1);
        $sql->bindValue(":quantidade", $maximo_selecao);
        $sql->execute();
        return true;
    }


    public function addOpcionais($idCompany, $idGrupo, $nome_opcional, $descricao, $valor){
        $sql =  $this->db->prepare("INSERT INTO opcionais SET
            idu                 = :idu,
            idg                 = :idg,
            opnome              = :opnome,
            opdescricao         = :opdescricao,
            valor               = :valor,
            status              = :status
        ");
        $sql->bindValue(":idu", $idCompany);
        $sql->bindValue(":idg", $idGrupo);
        $sql->bindValue(":opnome", $nome_opcional);
        $sql->bindValue(":opdescricao", $descricao);
        $sql->bindValue(":valor", $valor);
        $sql->bindValue(":status", 1);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }


    public function getListOpcionaisGroup($idGrupo, $idCompany){
        $sql = $this->db->prepare("SELECT * FROM opcionais WHERE idg = :idg AND idu = :idu");
        $sql->bindvalue(":idu", $idCompany);
        $sql->bindvalue(":idg", $idGrupo);
        $sql->execute();
        if($sql->rowCount()>0){
            return $sql->fetchAll();
        }else{
            return array();
        }
    }

    public function excluirAdicionall($id){
        $sql = $this->db->prepare("DELETE FROM opcionais WHERE id = :id");
        $sql->bindValue(":id", $id);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }
}