<?php

class Produto extends model{

    public function add($idu, $nome, $valor, $unidade_medida, $ingredientes, $categoria, $foto, $status){
        $sql = $this->db->prepare("INSERT INTO produtos SET 
            idu             = :idu,
            nome            = :nome,
            valor           = :valor,
            unidade_medida  = :unidade_medida,
            ingredientes    = :ingredientes,
            categoria       = :categoria,
            foto            = :foto,
            status          = :status
        ");
        $sql->bindValue(":idu",             $idu);
        $sql->bindValue(":nome",            $nome);
        $sql->bindValue(":valor",           $valor);
        $sql->bindValue(":unidade_medida",  $unidade_medida);
        $sql->bindValue(":ingredientes",    $ingredientes);
        $sql->bindValue(":categoria",       $categoria);
        $sql->bindValue(":foto",            $foto);
        $sql->bindValue(":status",          $status);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }

    public function getListProdutos($idCompany){
        $array = array();
        $sql = $this->db->prepare("SELECT * FROM produtos WHERE idu = :idu");
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            $array = $sql->fetchAll();
        }
        return $array;
    }


    public function getListByIdProduto($idProduto, $idCompany){
        $array = array();
        $sql = $this->db->prepare("SELECT * FROM produtos WHERE id = :id AND idu = :idu");
        $sql->bindValue(":idu", $idCompany);
        $sql->bindValue(":id", $idProduto);
        $sql->execute();
        if($sql->rowCount()>0){
            $array = $sql->fetch();
        }
        return $array;
    }
    

    public function getSelectprodutoCategory($idCategory, $idCompany){
        $array = array();
        $sql = $this->db->prepare("SELECT * FROM produtos WHERE categoria = :categoria AND idu = :idu");
        $sql->bindValue(":idu", $idCompany);
        $sql->bindValue(":categoria", $idCategory);
        $sql->execute();
        if($sql->rowCount()>0){
            $array = $sql->fetchAll();
        }
        return $array;
    }
}