function openModal(title, tm) {
  const tmModal = document.getElementById("tmModal");
  document.getElementById("exampleModalLabel").innerHTML = title;
  if (tm != "") {
    tmModal.classList.add("modal-" + tm);
  }

  const myModal = new bootstrap.Modal("#exampleModal", {
    keyboard: false,
    backdrop: "static",
  });
  myModal.show();
}

const inputBuscaProd = document.getElementById("name_prod");
const listProd = document.querySelector(".listProd");
inputBuscaProd.addEventListener("keyup", async () => {
  if (inputBuscaProd.value.length > 2) {
    //document.getElementById('ulListProd').innerHTML ='';

    let name_prod = inputBuscaProd.value;

    const formData = new FormData();
    formData.append("name_prod", name_prod);

    const data = await fetch("../pdv/ajax/buscaProd.php", {
      method: "POST",
      body: formData,
    });

    const response = await data.json();
    let html = "";
    if (response != "") {
      for (let item in response) {
        html +=
          '<li onclick="addProdListVenda(' +
          response[item].valor +
          ')"><span>' +
          response[item].nome +
          "</span><span>R$ " +
          formataMoeda(response[item].valor) +
          "</span></li>";
      }
    } else {
      html += "<li><span>Nenhum produto encontrado</span></li>";
    }

    document.getElementById("ulListProd").innerHTML = html;
    listProd.classList.toggle("activeListProd");
  }
});

function addProdListVenda(dados) {
  listProd.classList.remove("activeListProd");
  document.getElementById("price_prod").value = formataMoeda(dados);
  let qtd_prod = document.getElementById("qtd_prod").value;
  document.getElementById("total_price_prod").value = formataMoeda(
    dados * qtd_prod
  );
}

function calcQtdValorProd() {
  if (qtd_prod.value < 1) {
    qtd_prod.value = 1;
  } else {
    let price_prod = document.getElementById("price_prod").value;
    let qtd_prod = document.getElementById("qtd_prod").value;
    document.getElementById("total_price_prod").value = formataMoeda(
      price_prod.toString().replace(",", ".") * qtd_prod
    );
  }
}

function formataMoeda(valor) {
  return valor.toLocaleString("pt-br", { minimumFractionDigits: 2 });
}
