const addMenu = document.getElementById("addBtnMenu");
const btnDetalhesPedido = document.getElementById("btnDetalhesPedido");
const divContainerBtnPedido = document.getElementById("divContainerBtnPedido");

let cart = [];
addMenu.addEventListener("click", function (event) {
  let parentButton = event.target.closest("#addBtnMenu");

  if (parentButton) {
    const mesa = parentButton.getAttribute("data-mesa");
    const id = parentButton.getAttribute("data-id");
    const prod = parentButton.getAttribute("data-name");
    const price = parseFloat(parentButton.getAttribute("data-prace"));

    addToCart(mesa, id, prod, price);
  }
});

function addToCart(mesa, id, prod, price) {
  const existProditem = cart.find((item) => item.id === id);

  if (existProditem) {
    if (confirm(prod + "Já existe, deseja adicionar mais um?")) {
      existProditem.quantity += 1;
      notification("SUCESSO!!!", "Produto adicionado com sucesso", "success");
      return;
    }
    return;
  }
  cart.push({
    id,
    prod,
    price,
    quantity: 1,
    mesa,
  });
  notification("SUCESSO!!!", "Produto adicionado com sucesso", "success");
  divContainerBtnPedido.style.display = "flex";

  updateModalCarrinho();
}

function addPedido() {
  notification("SUCESSO!!!", "Pedido adicionado com sucesso", "success");
  closseModal();
  setTimeout(() => {
    window.location.href = urlSite + "/garcom.php";
  }, 2000);
}

function updateModalCarrinho() {
  openModal();
}

function openModal(title) {
  const myModal = document.getElementById("myModal");
  const titlemodal = document.getElementById("title-modal");
  titlemodal.innerHTML = title;
  myModal.style.display = "flex";
}
