<?php
if (isset($_COOKIE['pdvx'])) {
  $cod_id = $_COOKIE['pdvx'];
  
} else {
  header("location: sair.php");
}
date_default_timezone_set('America/Sao_Paulo');
include_once('../../funcoes/Conexao.php');
include_once('../../funcoes/Key.php');

$sqlEmp = $connect->prepare("SELECT * FROM config WHERE id = :id");
  $sqlEmp->bindValue(":id", $cod_id);
  $sqlEmp->execute();
  if($sqlEmp->rowCount()>0){

    $dataEmp = $sqlEmp->fetch();

  }
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="windows-1252">

  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="Sistema de PDV.">
  <meta name="author" content="MDINELLY">
  <title>CAIXA</title>
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/datatables/css/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <link href="../lib/SpinKit/css/spinkit.css" rel="stylesheet">
  <link rel="stylesheet" href="../css/slim.css">
</head>

<body>

  <div class="slim-navbar">
    <div class="container">
      <ul class="nav">
        <li class="nav-item">
          <a class="nav-link" href="pdv.php">
          <i class="fa fa-money" aria-hidden="true"></i>
            <span style="margin-left: 5px;"> VOLTAR</span>
          </a>
        </li>
        
        <li class="nav-item">
          <a class="nav-link" href="sair.php">
            <i class="icon ion-ios-analytics-outline"></i>
            <span>SAIR</span>
          </a>
        </li>
      </ul>
    </div>
  </div>

  <div class="slim-mainpanel">
    <div class="container">

    <h1 style="margin-top: 15px; color:brown" class="text-center">CAIXA - <?php echo $dataEmp['nomeempresa']; ?></h1>


      <div class="section-wrapper mg-t-20">
        <label class="section-title"><i class="fa fa-check-square-o" aria-hidden="true"></i> MOVIMENTAÇÂO
        </label>
        <hr>
        <div class="" style="margin-bottom: 10px;">
          <form name="buscaCaixa" method="GET">
            <div class="row">
              <div class="col-sm-4">
                <label style="font-weight: bold;">Data inicial</label>
                <input type="date" name="dataInicial" class="form-control" value="<?php echo !empty($_GET['dataInicial']) ? $_GET['dataInicial'] : ''; ?>">
              </div>

              <div class="col-sm-4">
                <label style="font-weight: bold;">Dadta Final</label>
                <input type="date" name="dataFinal" class="form-control" value="<?php echo !empty($_GET['dataFinal']) ? $_GET['dataFinal'] : ''; ?>">
              </div>

              <div class="col-sm-2">
                <label style="font-weight: bold;">Filtra por:</label>
                <!-- <input type="date" name="dataFinal" class="form-control" value="<?php echo !empty($_GET['dataFinal']) ? $_GET['dataFinal'] : ''; ?>"> -->
                <select class="form-control" name="filtro">
                  <option value="0" <?php if(isset($_GET['filtro']) && $_GET['filtro'] === "0"): echo "selected"; endif ?>>Todos</option>
                  <option value="5" <?php if(isset($_GET['filtro']) && $_GET['filtro'] === "5"): echo "selected"; endif ?>>Finalizados</option>
                  <option value="6" <?php if(isset($_GET['filtro']) && $_GET['filtro'] === "6"): echo "selected"; endif ?>>Cancelados</option>
                </select>
              </div>

              <div class="col-sm-2" style="display: block;">
                <label style="font-weight: bold; width: 100%; color:white;">.</label>
                <button class="btn btn-primary" style="width: 100%;">BUSCAR</button>
              </div>
            </div>
          </form>
        </div>
        <div class="table-wrapper">
          <table id="" class="table display responsive nowrap" width="100%">
            <thead>
              <tr>
                <th>COD PEDIDO</th>
                <th>CLIENTE</th>
                <th>DATA</th>
                <th class="text-center">STATUS</th>
                <th class="text-right">VALOR TOTAL</th>
              </tr>
            </thead>
            <tbody>

            <?php
            $dataInicial  = date('Y-m-d');
            $dataFinal    = date('Y-m-d');

            
              if(isset($_GET['filtro']) && !empty($_GET['filtro'])){
                $statusPadrao = 5;
              }

              
              if(isset($_GET['dataInicial']) && !empty($_GET['dataInicial']) && isset($_GET['dataFinal']) && !empty($_GET['dataFinal'])){
                  $dataInicial  = $_GET['dataInicial'];
                  $dataFinal    = $_GET['dataFinal'];
              }

              if(isset($_GET['filtro']) && !empty($_GET['filtro'])){
                $statusPadrao = $_GET['filtro'];
              }

              $totalCaixa = "SELECT SUM(vtotal) as somaTotal FROM pedidos WHERE idu = :idu AND data BETWEEN :dataInicial AND :dataFinal";
              if(isset($_GET['filtro']) && !empty($_GET['filtro'])){
                $totalCaixa .= " AND status = :status_pedido";
              } 
              $totalCaixa = $connect->prepare($totalCaixa);             
              
              $totalCaixa->bindValue(":idu", $cod_id);
              $totalCaixa->bindValue(":dataInicial", $dataInicial);
              $totalCaixa->bindValue(":dataFinal", $dataFinal);
              if(isset($_GET['filtro']) && !empty($_GET['filtro'])){
                $totalCaixa->bindValue(':status_pedido', $statusPadrao);
              }
              $totalCaixa->execute();
              if($totalCaixa->rowCount()>0){
                  $rowCaixa = $totalCaixa->fetch();
              }

              $sqlPedido = "SELECT * FROM pedidos WHERE idu = :idu AND data BETWEEN :dataInicial AND :dataFinal";
              $sqlPedido = $connect->prepare($sqlPedido);
              
              if(isset($_GET['filtro']) && !empty($_GET['filtro'])){
                $sqlPedido .= " AND status = :status_pedido";
              }              
                $sqlPedido->bindValue(':dataInicial', $dataInicial);
                $sqlPedido->bindValue(':dataFinal', $dataFinal);
             
              if(isset($_GET['filtro']) && !empty($_GET['filtro'])){
                $sqlPedido->bindValue(':status_pedido', $statusPadrao);
              }
              $sqlPedido->bindValue(":idu", $cod_id);
              $sqlPedido->execute();
              if($sqlPedido->rowCount()>0){
                  foreach($sqlPedido->fetchAll() as $dataPedido):

                    switch ($dataPedido['status']) {

                      case '2':
                        $status = "Cancelado";
                        $typeStatus = "danger";
                        break;

                        case '3':
                          $status = "Cancelado";
                          $typeStatus = "danger";
                          break;

                          case '4':
                            $status = "Cancelado";
                            $typeStatus = "danger";
                            break;

                            case '5':
                              $status = "Finalizado";
                              $typeStatus = "success";
                              break;
        
                            case '6':
                              $status = "Cancelado";
                              $typeStatus = "danger";
                              break;
        
                              default:
                                $status = "Outros";
                                $typeStatus = "info";
                              break;
                    }
              ?>
                <tr>
                  <td><?php echo $dataPedido['idpedido'];?></td>
                  <td><?php echo $dataPedido['nome']; ?></td>
                  <th><?php echo date('d/m/Y H:i', strtotime($dataPedido['entrada'])); ?></th>
                  <th class="text-center"><span class="text-<?php echo $typeStatus; ?>"><?php echo $status; ?></span></th>
                  <td class="text-right">R$ <?php echo number_format($dataPedido['vtotal'], 2, ",", "."); ?></td>
                </tr>
                <?php
                endforeach;
              }else{
                echo '<tr><td colspan="5">Nenhuma movimentação registrada</td></tr>';
                } ?>

                <tr>
                  <td colspan="3" class="text-left text-danger" style="font-weight: bold; font-size:20px;"></td>
                  <td colspan="1" class="text-right" style="font-weight: bold; font-size:20px;">SUB TOTAL:</td>
                  <td colspan="1" class="text-right" style="font-weight: bold; font-size:20px; color:green;">R$: <?php echo number_format($rowCaixa['somaTotal'], 2, ',', '.'); ?></td>
                </tr>

            </tbody>

          </table>
        </div>
      </div>

      <br>
      <br>

    </div><!-- container -->
  </div><!-- slim-mainpanel -->



  <script src="../lib/jquery/js/jquery.js"></script>
  <script src="../lib/datatables/js/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/js/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        "order": [
          [0, "desc"]
        ],
        responsive: true,
        language: {
          searchPlaceholder: 'Buscar...',
          sSearch: '',
          lengthMenu: '_MENU_ ítens',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>


  <script>
    var timeleft = 30;
    var downloadTimer = setInterval(function() {
      document.getElementById("progressBar").value = 30 - timeleft;
      timeleft -= 1;
      if (timeleft <= 0) {
        clearInterval(downloadTimer);
      }
    }, 1000);
  </script>

</body>

</html>