<?php
session_start();
if (isset($_COOKIE['pdvx']) && isset($_SESSION['appGarcom'])) {
    $cod_id = $_COOKIE['pdvx'];
    $id_garcom = $_SESSION['appGarcom'];
} else {
    header("location: sair.php");
}
include_once('../../funcoes/Conexao.php');
include_once('../../funcoes/Key.php');

//Query Mesas
$mesas = $connect->query("SELECT * FROM mesas WHERE idu = '$cod_id'");

//$mesas = array();

//Query Funciuonario (Garçom);
$garcom = $connect->query("SELECT * FROM funcionarios WHERE id = '$id_garcom' AND idu = '$cod_id' ");
$dadosgarcom = $garcom->fetch(PDO::FETCH_OBJ);


//$dadosPedidos = $pedido->fetch(PDO::FETCH_OBJ);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Premium Quality and Responsive UI for Dashboard.">
    <meta name="author" content="ThemePixels">
    <title>APP GARÇOM</title>
    <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
    <link href="../lib/datatables/css/jquery.dataTables.css" rel="stylesheet">
    <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
    <link href="../lib/SpinKit/css/spinkit.css" rel="stylesheet">
    <!-- <link rel="stylesheet" href="../css/slim.css"> -->
    <link href="./src/output.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" integrity="sha512-Fo3rlrZj/k7ujTnHg4CGR2D7kSs0v4LLanw2qksYuRlEzO+tcaEPQogQ0KaoGN26/zrn20ImR1DfuLWnOo7aBA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body class="bg-[#2D334B]">

    <div class="flex h-13 bg-[#63314B] text-white items-center justify-between px-2 text-sm">
        <span>MESAS</span>
        <span>GARÇOM: <?php echo $dadosgarcom->nome; ?></span>
        <a href="sair garcom.php">SAIR</a>
    </div>

    <span class="flex w-full bg-white">
        <progress value="0" max="30" id="progressBar" class="w-full h-1"></progress>
    </span>

    <main class="flex w-full grid grid-cols-2 md:grid-cols-4 lg:grid-cols-9 gap-2 px-2 mt-2">
        <?php if ($mesas) {
            foreach ($mesas as $mesa):
                $numeroMesa = $mesa['numero'];
                if ($numeroMesa < 10) {
                    $numeroMesa = "0" . $mesa['numero'];
                }

                $pedido = $connect->prepare("SELECT * FROM pedidos WHERE idu = :cod_id AND mesa = :mesa AND status = :status");
                $pedido->bindValue(":cod_id", $cod_id);
                $pedido->bindValue(":status", 2);
                $pedido->bindValue(":mesa", $numeroMesa);
                $pedido->execute();
                $pedidos = array();
                if ($pedido->rowCount() > 0) {
                    $pedidos = $pedido->fetch();
                }
                if (empty($pedidos)) { ?>
                    <a href="carrinhoprodutos.php?idpedido=<?= $id_pedido = rand(100000, 999999); ?>&idmesa=<?php echo $numeroMesa; ?>" class="bg-[#4A70F7] hover:bg-blue-500 flex flex-col h-30 rounded p-2">
                        <span class="text-sm text-white">Livre</span>
                        <strong class="h-16 flex items-center justify-center text-white text-5xl"><?php echo $numeroMesa; ?></strong>
                        <!-- <span class="text-white text-sm grid justify-items-end">Livre</span> -->
                    </a>
                <?php } else { ?>
                    <!-- IF DAS MESAS OCUPADAS -->
                    <!-- <a href="fecharpedidogarcom.php?idpedido=<?php echo $pedidos['idpedido']; ?>" class="bg-[#E2414D] flex flex-col h-30 rounded p-2"> -->
                    <div class="bg-[#E2414D] flex flex-col h-30 rounded p-2 hover:bg-red-500">
                        <span class="text-sm text-white"><?php echo empty($pedidos['nome']) ? "Ocupado" : $pedidos['nome']; ?></span>
                        <strong class="h-20 flex items-center justify-center text-white text-5xl"><?php echo $numeroMesa; ?></strong>
                        <div class="flex items-center justify-between gap-2">
                            <a href="#" class="bg-[#4A70F7] w-full py-2 flex items-center justify-center" title="Adicionar items"><i class="fa-solid fa-cart-plus text-white"></i></a>
                            <a href="fecharpedidogarcom.php?idpedido=<?php echo $pedidos['idpedido']; ?>" class="bg-green-500 w-full py-2 flex items-center justify-center"><i class="fa-solid fa-money-check-dollar text-white"></i></a>
                        </div>
                    </div>
        <?php }
            endforeach;
        } ?>


    </main>

    <?php if (empty($mesas)) { ?>
        <div class="flex items-center bg-yellow-500 m-2 p-2 rounded">
            <span>
                <svg viewBox="0 0 20 20" width="30" fill="currentColor" data-slot="icon" aria-hidden="true" class="jxi jya">
                    <path d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495ZM10 5a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-3.5A.75.75 0 0 1 10 5Zm0 9a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" clip-rule="evenodd" fill-rule="evenodd"></path>
                </svg>
            </span>
            <h4 class="text-[11px]">Nenhuma mesa cadastrada para o estabelecimento</h4>
        </div>
    <?php } ?>


</body>

<script>
    setTimeout(function() {
        window.location.reload(1);
    }, 15000);

    var timeleft = 15;

    var downloadTimer = setInterval(function() {
        document.getElementById("progressBar").value = 15 - timeleft;
        timeleft -= 1;
        if (timeleft <= 0) {
            clearInterval(downloadTimer);
        }
    }, 1000);
</script>


</html>