//Listagem de clientes
setListData(5, "clientes/listAllClientes", "listDataAll");

//Envio de formulario de cadastro de clientes
async function formSubmitAdd(){
    const formAddCliente = document.getElementById('form_add_cliente');
    const formData = new FormData(formAddCliente);

    const data = await fetch(url_js+'clientes/add', {
        method: "POST",
        body: formData
    });

    const response = await data.json();
    if(response.msg === "sucesso"){
        alertNotification("SUCESSO!!!", "Dados do cliente salvos com sucesso", "success", "right");
        closeModal();
        setTimeout(()=>{
            setListData(5, "clientes/listAllClientes", "listDataAll");
        }, 1000);
    }else if(response.msg === "erroEmpty"){
        alertNotification("ATENÇÃO!!!", "Preecnha todos os campos", "warning", "right");
    }else if(response.msg === "erroAdd"){
        alertNotification("ERRO!!!", "Erro ao tentar salvar dados do cliente, tente novamente", "danger", "right");
    }
}

async function formSubmitEdit(){
    const formEditCliente = document.getElementById('form_edit_cliente');
    const formData = new FormData(formEditCliente);

    const data = await fetch(url_js+'clientes/edit', {
        method: "POST",
        body: formData
    });

    const response = await data.json();

    if(response.msg === "sucesso"){
        alertNotification("SUCESSO!!!", "Dados do cliente alterado com sucesso", "success", "right");
        closeModal();
        setTimeout(()=>{
            setListData(5, "clientes/listAllClientes", "listDataAll");
        }, 1000);
    }else if(response.msg === "erroEmpty"){
        alertNotification("ATENÇÃO!!!", "Preecnha todos os campos", "warning", "right");
    }else if(response.msg === "erroUpdate"){
        alertNotification("ERRO!!!", "Erro ao tentar salvar dados do cliente, tente novamente", "danger", "right");
    }
}


async function excluir(id_cliente){
    if(confirm("Deseja realmente excluir?")){
        const data = await fetch(url_js+'clientes/excluir/'+id_cliente);
    
        const response = await data.json();
    
        if(response.msg === "sucesso"){
            alertNotification("SUCESSO!!!", "Dados excluido com sucesso", "success", "right");
            setTimeout(()=>{
                setListData(5, "clientes/listAllClientes", "listDataAll");
            }, 1000);
        }else if(response.msg === "erroId"){
            alertNotification("ATENÇÃO!!!", "Erro paramentos não informados", "warning", "right");
        }else if(response.msg === "erroDel"){
            alertNotification("ERRO!!!", "Erro ao tentar excluido informações do cliente", "danger", "right");
        }else if(response.msg === "erroDebito"){
            alertNotification("ATENÇÃO!!!", "Cliente possue debitos e não pode ser excluido", "warning", "right");
        }
    }
}


async function searchCliente(){
    
}

