<?php
//sleep(1);
class categoriasController extends controller {

    public function __construct() {
        parent::__construct();

        $u = new Users();
        if($u->isLogged() == false) {
        	header("Location: ".BASE_URL."login");
        	exit;
        }
    }

    public function index() {
        $data = array(
            "nameArq" => "categorias",
            "namePag" => "Categorias",
            "textPag" => "",
        );
        $u = new Users();
        $u->setLogged();

        $data['name_user'] = $u->getUserName();

        $this->loadTemplate('categorias', $data);
    }

    public function getListCategorias(){

        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();
        $cat = new Categoria;

        if(!empty($cat->getListAllCategory($idCompany))){
                foreach($cat->getListAllCategory($idCompany) as $dataCategoria): ?>
                   <div class="col-sm-2">
                        <span class="colCatPdv" onclick="selectProdutoCategory(<?php echo $dataCategoria['id']; ?>)">
                            <!-- <img src="" width="60px"> -->
                            <?php echo $dataCategoria['nome']; ?>
                        </span>
                    </div>
                <?php endforeach;
        }else{
            echo "<li>Nenhuma vategoria registrada</li>";
        }
    }
    


    public function selectProdutoCategory($idCategory){
        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();
        $prod = new Produto;
        $dataProd = $prod->getSelectprodutoCategory($idCategory, $idCompany);
        if(!empty($dataProd)){
            echo '<div class="containerProdCat">';
            foreach($dataProd as $produto): ?>
                    <span class="spanContainer" onclick="openModal('<?php echo $produto['nome']; ?>', 'categorias/viewProduto/<?php echo $produto['id']; ?>')">
                        <div class="imgProdPdv">
                            <img src="../../../img/fotos_produtos/<?php echo $produto['foto']; ?>">
                        </div>
                        <div class="titleProd">
                            <?php echo $produto['nome']; ?>
                            <span class="priceProd">
                                <h5><strong>R$ <?php echo formatamoeda($produto['valor']); ?></strong></h5>
                                <button class="btn btn-sm btn-success">+</button>
                            </span>
                        </div>                        
                    </span>
            <?php endforeach;
            echo '</div>';
        }else{
            echo '<div class="alert alert-info text-center">Nenhum produto registrado para essa categoria</div>';
        }
    }


    public function viewProduto($idProduto){
        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();
        $prod = new Produto;
        $dataProd = $prod->getListByIdProduto($idProduto, $idCompany);

        $gp = new Grupo(); 
        ?>

        <form name="form_lanca_produto_mesa" id="form_lanca_produto_mesa" method="POST">
            <div class="row" style="max-width: 400px; margin: 0 auto;">
                <div class="col-sm-12 text-center">
                    <img src="../../../img/fotos_produtos/<?php echo $dataProd['foto']; ?>" width="400">
                </div>

                <div class="col-sm-12">
                    <h5><strong>INGREDIENTES</strong></h5>
                    <p><?php echo $dataProd['ingredientes']; ?></p>
                </div>
                <?php
                    if(!empty($gp->getGrupos($idCompany))){
                        echo '<h3 class="text-center" style="text-transform: uppercase; font-weight: bold;">Adicionais</h3><br><hr>';
                        foreach($gp->getGrupos($idCompany) as $dataGrupo): 
                ?>

                <div class="col-sm-12">
                    <h6 style="text-transform:uppercase; font-size: 14px; font-weight: bold; margin-top: 5px;"><?php echo $dataGrupo['nomegrupo']; ?></h6>
                    <?php
                        if(!empty($gp->getSubGrupos($idCompany, $dataGrupo['Id']))){
                            foreach($gp->getSubGrupos($idCompany, $dataGrupo['Id']) as $dataSubGrupo): ?>
                                <div class="col-sm-12">
                                    <label id="sub-<?php echo $dataSubGrupo['id']; ?>" id-price="<?php echo $dataSubGrupo['valor']; ?>" onchange="addPriceOp('<?php echo $dataSubGrupo['valor']; ?>')" style="width: 100%; padding: 5px 0px;">
                                        <div class="infoBox"
                                        data-id="<?php echo $dataSubGrupo['id']; ?>" 
                                        data-valor="<?php echo $dataSubGrupo['valor']; ?>"
                                        style="width: 100%; color: brown; display: flex; justify-content: space-between; flex-redirection: column; align-items: center;">
                                            <span>
                                                <input type="checkbox" name="subAdd[]" value="<?php echo $dataSubGrupo['valor']; ?>" id="sub-<?php echo $dataSubGrupo['id']; ?>">
                                                <?php echo $dataSubGrupo['opnome']; ?>
                                            </span>
                                            <?php echo "R$ ". formatamoeda($dataSubGrupo['valor']);?>
                                        </div>
                                    </label>
                                </div>
                            <?php endforeach;
                        }
                    ?>
                    
                </div>

                <?php endforeach;
                    };
                    ?>

                <div class="col-sm-12" style="text-align: right;">
                    <h3>
                        <strong style="color: #00A3D9;" id="totalPriceTextModel">
                            R$ <span id="totalPedido"><?php echo $dataProd['valor']; ?></span>                           
                        </strong>
                        <input type="hidden" id="totalPriceProdModel" name="totalPriceProdModel" value="<?php echo $dataProd['valor']; ?>">
                        <input type="hidden" id="totalPriceModel" name="totalPriceModel" value="<?php echo $dataProd['valor']; ?>">
                    </h3>
                </div>

                <div class="col-sm-12" style="text-align: right; margin-top:3%">
                    <button class="btn btn-primary" style="border-radius: 0; width: 50%;">Adicionar</button>
                </div>
            </div>
        </form>

    <?php }


public function getListCategoriasTable(){
    $u = new Users();
    $u->setLogged();
    $idCompany = $u->getIdCompany();

    $cat = new Categoria;

    if($cat->getListAllCategory($idCompany)){
        foreach($cat->getListAllCategory($idCompany) as $dataCategory):
    ?>

    <tr>
        <td><strong><?php echo $dataCategory['nome']; ?></strong></td>
        <td><?php echo $dataCategory['posicao']; ?></td>
        <td class="text-center">
            <button onclick="openModal('Editar Categoria', 'categorias/formEditCategoria/<?php echo $dataCategory['id']; ?>')" class="btn btn-success btn-sm" title="Editar Produto" style="color: white;"><i class="fa-regular fa-pen-to-square"></i></button>
            <button onclick="excluirCategoria(<?php echo $dataCategory['id']; ?>)" class="btn btn-danger btn-sm" title="Excluir Produto" style="color: white;"><i class="fa-solid fa-trash-can"></i></button>
        </td>
    </tr>

<?php endforeach;
        }
     }

     public function formAddCategoria(){ ?>
        <form name="form_add_categoria" id="form_add_categoria" method="post">
            <div class="row">
                <div class="col-sm-6">
                    <label class="label">Categoria</label>
                    <input name="nome_categoria" class="form-control" type="text">
                </div>

                <div class="col-sm-6">
                    <label class="label">Pisição</label>
                    <input name="posicao_categoria" class="form-control" type="number" value="1">
                </div>

                <div class="col-sm-12">
                    <label class="label">Imagem para categoria</label>
                    <input name="image_categoria" class="form-control" type="file">
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitAddCategoria()">Salvar</button>
                </div>
            </div>
        </form>
     <?php }


     public function formEditCategoria($idCategory){
        
        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();

        $cat = new Categoria;

        $dataCategory = $cat->getCategoriaById($idCompany, $idCategory);

        
        ?>
        <form name="form_edit_categoria" id="form_edit_categoria" method="post">
            <div class="row">
                <div class="col-sm-6">
                    <label class="label">Categoria</label>
                    <input name="nome_categoria" value="<?php echo $dataCategory['nome']; ?>" class="form-control" type="text">
                    <input name="id_categoria" value="<?php echo $dataCategory['id']; ?>" type="hidden">
                </div>

                <div class="col-sm-6">
                    <label class="label">Pisição</label>
                    <input name="posicao_categoria" value="<?php echo $dataCategory['posicao']; ?>" class="form-control" type="number">
                </div>

                <div class="col-sm-12">
                    <label class="label">Imagem para categoria</label>
                    <input name="image_categoria" class="form-control" type="file">
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitEditCategoria()">Salvar</button>
                </div>
            </div>
        </form>
     <?php }


public function add(){
    $data = ["msg"];

    $nome_categoria     = filter_input(INPUT_POST, "nome_categoria");
    $posicao_categoria  = filter_input(INPUT_POST, "posicao_categoria");

    $u = new Users();
    $u->setLogged();
    $idCompany = $u->getIdCompany();

    $upload = new Functions;
    $cat = new Categoria;

    if(empty($nome_categoria) || empty($posicao_categoria)){
        $data['msg'] = "erroEmpty";
    }else{
        if($cat->getPositionCategory($idCompany, $posicao_categoria) === true){
            $data['msg'] = "erroPosicao";
        }else{
            if($cat->getVerifyCategory($idCompany, $nome_categoria) === true){
                $data['msg'] = "erroNomeCategoria";
            }else{
                if(isset($_FILES['image_categoria']['name']) && !empty($_FILES['image_categoria']['name'])){
                    $nameImg = $upload->uploadImagens($_FILES['image_categoria'], "categoria", 100, 100);
                    if($nameImg === "erroTipoImg"){
                        $data['msg'] = "erroTypeImg";
                    }else{
                        if($cat->add($idCompany, $nome_categoria, $posicao_categoria, $nameImg) === true){
                            $data['msg'] = "sucesso";
                        }else{
                            $data['msg'] = "erroAdd";
                        }
                    }
                    
                }else{
                    $data['msg'] = "erroImagem";
                }
            }            
        }        
    }

    echo json_encode($data);
}

public function edit(){
    $data = ["msg"];

    $id_categoria       = filter_input(INPUT_POST, "id_categoria");
    $nome_categoria     = filter_input(INPUT_POST, "nome_categoria");
    $posicao_categoria  = filter_input(INPUT_POST, "posicao_categoria");

    $u = new Users();
    $u->setLogged();
    $idCompany = $u->getIdCompany();

    $upload = new Functions;
    $cat = new Categoria;

    $dataCategory = $cat->getCategoriaById($idCompany, $id_categoria);

    if(empty($nome_categoria) || empty($posicao_categoria)){
        $data['msg'] = "erroEmpty";
    }else{
        if(isset($_FILES['image_categoria']['name']) && !empty($_FILES['image_categoria']['name'])){
            $pastaImg = DIRIMGUP.'/categoria/'.$dataCategory['url'];
            if(file_exists($pastaImg)){
                unlink(DIRIMGUP.'/categoria/'.$dataCategory['url']);
            }
            
            $nameImg = $upload->uploadImagens($_FILES['image_categoria'], "categoria", 300, 300);
            if($nameImg === "erroTipoImg"){
                $data['msg'] = "erroTypeImg";
            }else{
                $cat->edit($idCompany, $id_categoria, $nome_categoria, $posicao_categoria, $nameImg);
                $data['msg'] = "sucesso";
            }
            
        }else{
            $data['msg'] = "erroImagem";
        }     
    }

    echo json_encode($data);
}

}

//2024440484376



