<?php
//sleep(2);
class clientesController extends controller
{

    public function __construct()
    {
        parent::__construct();

        $u = new Users();
        if ($u->isLogged() == false) {
            header("Location: " . BASE_URL . "login");
            exit;
        }
    }

    public function index()
    {
        $data = array(
            "nameArq" => "clientes",
            "namePag" => "Clientes",
            "textPag" => "",
        );
        $u = new Users();
        $u->setLogged();

        $data['idCompany'] = $u->getIdCompany();
        $data['name_user'] = $u->getUserName();

        $this->loadTemplate('clientes', $data);
    }

    public function formAdd()
    {

        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();

        $br = new Bairro();

?>
        <form name="form_add_cliente" id="form_add_cliente" method="post" enctype='multipart/form-data'>
            <div class="row">
                <div class="col-sm-6">
                    <label class="label">Nome Completo</label>
                    <input type="text" name="nome_cliente" class="form-control" placeholder="Fulano de Tal Costa">
                </div>

                <div class="col-sm-6">
                    <label class="label">E-mail</label>
                    <input type="email" name="email_cliente" class="form-control" placeholder="contato@exemplo.com.br">
                </div>

                <div class="col-sm-3">
                    <label class="label">CPF</label>
                    <input type="text" name="cpf_cliente" class="form-control" placeholder="999.999.999-99">
                </div>

                <div class="col-sm-3">
                    <label class="label">Celular</label>
                    <input type="text" name="cel_cliente" class="form-control" placeholder="(99) 99999999">
                </div>

                <div class="col-sm-3">
                    <label class="label">Limite de venda</label>
                    <input type="number" name="limite_cliente" class="form-control" placeholder="200,00" value="350">
                </div>

                <div class="col-sm-3">
                    <label class="label">Status</label>
                    <select class="form-control" name="status_cliente">
                        <option value="1">Ativo</option>
                        <option value="0">Inativo</option>
                    </select>
                </div>

                <div class="col-sm-3">
                    <label class="label">CEP</label>
                    <input type="number" name="cep_cliente" class="form-control" placeholder="99.999-999">
                </div>

                <div class="col-sm-6">
                    <label class="label">Endereço</label>
                    <input type="text" name="endereco_cliente" class="form-control" placeholder="Rua: Aparecida Costa">
                </div>

                <div class="col-sm-3">
                    <label class="label">Número</label>
                    <input type="number" name="numero_cliente" class="form-control" placeholder="999">
                </div>

                <div class="col-sm-4">
                    <label class="label">Bairro</label>
                    <select name="bairro_cliente" class="form-control">
                        <?php
                        if ($br->getAllBairros($idCompany)) {
                            echo '<option value="0">Selecione um Bairro</option>';
                            foreach ($br->getAllBairros($idCompany) as $dataBairro) {
                                echo '<option value=' . $dataBairro['id'] . '>' . $dataBairro['bairro'] . '</option>';
                            }
                        } else {
                            echo '<option value="0">Nenhum bairro registrado</option>';
                        } ?>

                    </select>
                </div>

                <div class="col-sm-4">
                    <label class="label">Cidade</label>
                    <input type="text" name="cidade_cliente" class="form-control" placeholder="Sampa Paulista">
                </div>

                <div class="col-sm-4">
                    <label class="label">Estado</label>
                    <input type="text" name="estado_cliente" class="form-control" placeholder="São Paulo">
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitAdd()">Salvar</button>
                </div>

            </div>
        </form>
    <?php }

    public function add(){

        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();

        $data = array("msg");
        $nome_cliente                 = filter_input(INPUT_POST, 'nome_cliente');
        $email_cliente                = filter_input(INPUT_POST, 'email_cliente');
        $cpf_cliente                  = filter_input(INPUT_POST, 'cpf_cliente');
        $cel_cliente                  = filter_input(INPUT_POST, 'cel_cliente');
        $limite_cliente               = filter_input(INPUT_POST, 'limite_cliente');
        $status_cliente               = filter_input(INPUT_POST, 'status_cliente');
        $cep_cliente                  = filter_input(INPUT_POST, 'cep_cliente');
        $endereco_cliente             = filter_input(INPUT_POST, 'endereco_cliente');
        $numero_cliente               = filter_input(INPUT_POST, 'numero_cliente');
        $bairro_cliente               = filter_input(INPUT_POST, 'bairro_cliente');
        $cidade_cliente               = filter_input(INPUT_POST, 'cidade_cliente');
        $estado_cliente               = filter_input(INPUT_POST, 'estado_cliente');

        if(
        empty($nome_cliente) ||
        empty($cpf_cliente) ||
        empty($cel_cliente) ||
        empty($status_cliente) ||
        empty($cep_cliente) || 
        empty($endereco_cliente) ||
        empty($numero_cliente) ||
        empty($bairro_cliente) ||
        empty($cidade_cliente) ||
        empty($estado_cliente)
        ){
            $data['msg'] = "erroEmpty";
        }else{
            $cl = new Cliente();
            if($cl->add($idCompany, $nome_cliente, $email_cliente, $cpf_cliente, $cel_cliente, $limite_cliente, $status_cliente, $cep_cliente, $endereco_cliente, $numero_cliente, $bairro_cliente, $cidade_cliente, $estado_cliente) === true){
                $data['msg'] = "sucesso";
            }else{
                $data['msg'] = "erroAdd";
            }
        }


        echo json_encode($data);
    }
    public function edit(){

        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();

        $data = array("msg");
        $id_cliente                 = filter_input(INPUT_POST, 'id_cliente');
        $nome_cliente                 = filter_input(INPUT_POST, 'nome_cliente');
        $email_cliente                = filter_input(INPUT_POST, 'email_cliente');
        $cpf_cliente                  = filter_input(INPUT_POST, 'cpf_cliente');
        $cel_cliente                  = filter_input(INPUT_POST, 'cel_cliente');
        $limite_cliente               = filter_input(INPUT_POST, 'limite_cliente');
        $status_cliente               = filter_input(INPUT_POST, 'status_cliente');
        $cep_cliente                  = filter_input(INPUT_POST, 'cep_cliente');
        $endereco_cliente             = filter_input(INPUT_POST, 'endereco_cliente');
        $numero_cliente               = filter_input(INPUT_POST, 'numero_cliente');
        $bairro_cliente               = filter_input(INPUT_POST, 'bairro_cliente');
        $cidade_cliente               = filter_input(INPUT_POST, 'cidade_cliente');
        $estado_cliente               = filter_input(INPUT_POST, 'estado_cliente');

        if(
        empty($nome_cliente) ||
        empty($cpf_cliente) ||
        empty($cel_cliente) ||
        empty($status_cliente) ||
        empty($cep_cliente) || 
        empty($endereco_cliente) ||
        empty($numero_cliente) ||
        empty($bairro_cliente) ||
        empty($cidade_cliente) ||
        empty($estado_cliente)
        ){
            $data['msg'] = "erroEmpty";
        }else{
            $cl = new Cliente();
            if($cl->edit($idCompany, $id_cliente, $nome_cliente, $email_cliente, $cpf_cliente, $cel_cliente, $limite_cliente, $status_cliente, $cep_cliente, $endereco_cliente, $numero_cliente, $bairro_cliente, $cidade_cliente, $estado_cliente) === true){
                $data['msg'] = "sucesso";
            }else{
                $data['msg'] = "erroUpdate";
            }
        }


        echo json_encode($data);
    }

    public function formEdit($idCliente)
    {

        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();

        $br = new Bairro();

        $cl = new Cliente();
        $dataCliente = $cl->getByIdCliente($idCompany, $idCliente);

    ?>
        <form name="form_edit_cliente" id="form_edit_cliente" method="post" enctype='multipart/form-data'>
            <div class="row">
            <script>
                $(document).ready(function(){
                    $('#cep_cliente').mask('00.000-000');
                })
                </script>
            <div class="col-sm-12">
                    <div class="row">
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="dash-widget">
                            <div class="dash-widgetimg">
                                <span><img src="assets/img/icons/dash2.svg" alt="img"></span>
                            </div>
                            <div class="dash-widgetcontent">
                                <h5>R$<span class="counters"><?php echo formatamoeda($dataCliente['limite_credito']); ?></span></h5>
                                <h6>Limite Crédito</h6>
                            </div>
                        </div>
                    </div>

                        <div class="col-lg-6 col-sm-6 col-12">
                            <div class="dash-widget dash3">
                                <div class="dash-widgetimg">
                                    <span><img src="assets/img/icons/dash3.svg" alt="img"></span>
                                </div>
                                <div class="dash-widgetcontent">
                                    <h5>R$<span class="counters"><?php echo formatamoeda($dataCliente['limite_disponivel']); ?></span></h5>
                                    <h6>Créditos</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6">
                    <label class="label">Nome Completo</label>
                    <input type="text" name="nome_cliente" value="<?php echo $dataCliente['nome_cliente']; ?>" class="form-control" placeholder="Fulano de Tal Costa">
                    <input type="hidden" name="id_cliente" value="<?php echo $dataCliente['id_cliente']; ?>">
                </div>

                <div class="col-sm-6">
                    <label class="label">E-mail</label>
                    <input type="email" name="email_cliente" value="<?php echo empty($dataCliente['email_cliente']) ? '' : $dataCliente['email_cliente']; ?>" class="form-control" placeholder="contato@exemplo.com.br">
                </div>

                <div class="col-sm-3">
                    <label class="label">CPF</label>
                    <input type="text" name="cpf_cliente" value="<?php echo empty($dataCliente['cpf_cliente']) ? '' : $dataCliente['cpf_cliente']; ?>" class="form-control cpf" placeholder="999.999.999-99">
                </div>

                <div class="col-sm-3">
                    <label class="label">Celular</label>
                    <input type="text" name="cel_cliente" value="<?php echo empty($dataCliente['cel_cliente']) ? '' : $dataCliente['cel_cliente']; ?>" class="form-control cel" placeholder="(99) 99999999">
                </div>

                <div class="col-sm-3">
                    <label class="label">Limite de venda</label>
                    <input type="number" name="limite_cliente" value="<?php echo empty($dataCliente['limite_credito']) ? '' : $dataCliente['limite_credito']; ?>" class="form-control" placeholder="200,00" value="350">
                </div>

                <div class="col-sm-3">
                    <label class="label">Status</label>
                    <select class="form-control" name="status_cliente">
                        <option value="1" <?php echo $dataCliente['status_cliente'] == 1 ? "selected" : ""; ?>>Ativo</option>
                        <option value="0" <?php echo $dataCliente['status_cliente'] == 0 ? "selected" : ""; ?>>Inativo</option>
                    </select>
                </div>

                <div class="col-sm-3">
                    <label class="label">CEP</label>
                    <input type="text" name="cep_cliente" id="cep_cliente" value="<?php echo empty($dataCliente['cep_cliente']) ? '' : $dataCliente['cep_cliente']; ?>" class="form-control" placeholder="99.999-999">
                </div>

                <div class="col-sm-6">
                    <label class="label">Endereço</label>
                    <input type="text" name="endereco_cliente" value="<?php echo empty($dataCliente['endereco_cliente']) ? '' : $dataCliente['endereco_cliente']; ?>" class="form-control" placeholder="Rua: Aparecida Costa">
                </div>

                <div class="col-sm-3">
                    <label class="label">Número</label>
                    <input type="number" name="numero_cliente" value="<?php echo empty($dataCliente['numero_cliente']) ? '' : $dataCliente['numero_cliente']; ?>" class="form-control" placeholder="999">
                </div>

                <div class="col-sm-4">
                    <label class="label">Bairro</label>
                    <select name="bairro_cliente" class="form-control">
                        <?php
                        if ($br->getAllBairros($idCompany)) {
                            echo '<option value="0">Selecione um Bairro</option>';
                            foreach ($br->getAllBairros($idCompany) as $dataBairro) { ?>
                                <option value="<?php echo $dataBairro['id']; ?>" <?php echo $dataBairro['id'] == $dataCliente['id_bairro'] ? "selected" : ""; ?>><?php echo $dataBairro['bairro']; ?></option>';
                            <?php }
                        } else {
                            echo '<option value="0">Nenhum bairro registrado</option>';
                        } ?>

                    </select>
                </div>

                <div class="col-sm-4">
                    <label class="label">Cidade</label>
                    <input type="text" name="cidade_cliente" value="<?php echo empty($dataCliente['cidade_cliente']) ? '' : $dataCliente['cidade_cliente']; ?>" class="form-control" placeholder="Sampa Paulista">
                </div>

                <div class="col-sm-4">
                    <label class="label">Estado</label>
                    <input type="text" name="estado_cliente" value="<?php echo empty($dataCliente['estado_cliente']) ? '' : $dataCliente['estado_cliente']; ?>" class="form-control" placeholder="São Paulo">
                </div>

                <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between'>
                    <button type='button' class='btn btn-danger' onclick='closeModal()'>Cancelar</button>
                    <button type='button' class='btn btn-success' onclick="formSubmitEdit()">Salvar</button>
                </div>

            </div>
        </form>
<?php }


public function listAllClientes(){
    $u = new Users();
    $u->setLogged();
    $idCompany = $u->getIdCompany();

    $cl = new Cliente();

    if($cl->getListAllCliente($idCompany)){

        foreach($cl->getListAllCliente($idCompany) as $dataCliente):
            switch ($dataCliente['status_cliente']) {
                case 'Active':
                    $status = "Ativo";
                    $type = "lightgreen";
                    break;
                    
                case 'Disabled':
                    $status = "inativo";
                    $type = "lightred";
                    break;
            }
    ?>
        <tr>
            <td style="font-weight: bold; text-transform: uppercase;"><?php echo $dataCliente['nome_cliente']; ?></td>
            <td><?php echo $dataCliente['cpf_cliente']; ?></td>
            <td><?php echo $dataCliente['cel_cliente']; ?></td>
            <td style="color: green; font-weight: bold;">R$ <?php echo formatamoeda($dataCliente['limite_credito']); ?> <i class="fa fa-angle-up" data-bs-toggle="tooltip" title="" data-bs-original-title="fa fa-angle-up" aria-label="fa fa-angle-up"></i></td>
            <td style="color: red; font-weight: bold;">R$ <?php echo formatamoeda($dataCliente['limite_disponivel']); ?> <i class="fa fa-angle-down" data-bs-toggle="tooltip" title="" data-bs-original-title="fa fa-angle-down" aria-label="fa fa-angle-down"></i></td>
            <td><span class="badges bg-<?php echo $type; ?>"><?php echo $status; ?></span></td>
            <td style="display: flex; gap:10px" class="text-center">
                <a class="confirm-text" href="javascript:void(0);" onclick="openModal('Editar Cliente', 'clientes/formEdit/<?php echo $dataCliente['id_cliente']; ?>')">
                    <img src="assets/img/icons/edit.svg" alt="img">
                </a>
                <a class="confirm-text" href="javascript:void(0);" onclick="excluir(<?php echo $dataCliente['id_cliente']; ?>)">
                    <img src="assets/img/icons/delete.svg" alt="img">
                </a>
            </td>
        </tr>
    <?php endforeach; }else{
            echo '<tr class="text-center text-danger"><td colspan="7">Nenhum registro encontrado</td></tr>';
    } 
}


public function listAllClientesPdv(){
    $u = new Users();
    $u->setLogged();
    $idCompany = $u->getIdCompany();

    $cl = new Cliente();

    if($cl->getListAllCliente($idCompany)){
        echo '<div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead>
            <tr style="text-transform: uppercase;">
                <th>Nome</th>
                <th width="100">Ação</th>
            </tr>
            </thead>
            <tbody>';
        foreach($cl->getListAllCliente($idCompany) as $dataCliente):
            switch ($dataCliente['status_cliente']) {
                case 'Active':
                    $status = "Ativo";
                    $type = "lightgreen";
                    break;
                    
                case 'Disabled':
                    $status = "inativo";
                    $type = "lightred";
                    break;
            }
    ?>
    
    <tr>
        <td><?php echo $dataCliente['nome_cliente']; ?></td>
        <td><button class="btn btn-warning btn-sm" onclick="btnAddClientePdv('<?php echo $dataCliente['id_cliente']; ?>', '<?php echo $dataCliente['nome_cliente']; ?>')">Adicionar</button></td>
    </tr>
        
    <?php endforeach;
    
        echo '</tbody>
            </table>
        </div>';
}else{
            echo '<tr class="text-center text-danger"><td colspan="7">Nenhum registro encontrado</td></tr>';
    } 
}


    public function excluir($id_cliente){
        $cl = new Cliente();
        $db = new Debitos();

        $u = new Users();
        $u->setLogged();
        $idCompany = $u->getIdCompany();

        $data = array("msg");

        if(empty($id_cliente)){
            $data['msg'] = "erroId";
        }else{
            if($db->getFerifyDebitoByIdCliente($idCompany, $id_cliente) === true){
                $data['msg'] = "erroDebito";
            }else{
                if($cl->excluir($id_cliente) === true){
                    $data['msg'] = "sucesso";
                }else{
                    $data['msg'] = "erroDel";
                }
            }
        }
        echo json_encode($data);
    }


    
}
