<?php
class pedidosController extends controller {

    public function __construct() {
        parent::__construct();

        $u = new Users();
        if($u->isLogged() == false) {
        	header("Location: ".BASE_URL."login");
        	exit;
        }
    }

    public function index() {
        $data = array(
            "nameArq" => "dashboard",
            "namePag" => "Dashboard",
            "textPag" => "",
        );
        $u = new Users();
        $u->setLogged();

        $data['name_user'] = $u->getUserName();

        $this->loadTemplate('home', $data);
    }

    public function formConfirmPassword(){
        ?>
        <form id="formConfirmPassword" name="formConfirmPassword" enctype="multipart/form-data" method="post">

            <div class="col-sm-12">
                <label class="label">Informe sua senha de Operador</label>
                <input type="text" name="confirmPassword" class="form-control" style="padding: 5px; text-align: center; font-size:40px">
            </div>

            <div class='col-sm-12' style='display:flex; margin-top: 2%; justify-content: space-between; gap:10px'>
                <button type='button' class='btn btn-danger' onclick='closeModal()' style="padding: 15px; width:200px">Cancelar</button>
                <button type='button' class='btn btn-success' onclick="formSubmitVerifyPassword()" style="padding: 15px; width:200px">Salvar</button>
            </div>
        </form>
    <?php }


public function verifyPasswordOpr(){
    $data = array();
    $u = new Users();
    $u->setLogged();

    if(!empty($_POST['confirmPassword'])){
        
        if($u->verifyPasswordOpr($u->getIdUser(), $_POST['confirmPassword']) === true){
            $data['msg'] = "sucesso";
        }else{
            $data['msg'] = "erroPasswordNotConfirm";
        }
    }else{
        $data['msg'] = "erroEmpty";
    }   

    echo json_encode($data);
}

    public function formFinalizarVenda(){
        if(isset($_SESSION['getListVendas'])){
            //print_r($_SESSION['getListVendas']);

            $u = new Users();
            $u->setLogged();
            $cl = new Cliente;
            $ms = new Mesas;

            $dataMesas = $ms->getListMesas($u->getIdCompany());

            $dataCl = $cl->getListAllCliente($u->getIdCompany());

            ?>
            <form name="formFinalizarVenda" id="formFinalizarVenda" method="POST" enctype="multipart/form-data">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr style="text-transform: uppercase;">
                                <th>Produto</th>
                                <th>Qtd</th>
                                <th>Valor Uni</th>
                                <th class="text-right" width="100">Valor Total</th>
                                <!-- <th>Ação</th> -->
                            </tr>
                        </thead>
                        <tbody class="tbodyGetListModalFinalizarVenda">
                            <?php 
                            $subTotal = "0.00";
                                foreach($_SESSION['getListVendas'] as $key => $value):
                                    $valorTotalItem = $value['valorProduto'] * $value['qtdProduto'];
                                    $subTotal += $valorTotalItem;
                            ?>
                            
                            <tr>
                                <td>
                                    <?php echo $value['nomeProduto']; ?>
                                    <input type="hidden" name="nome_produto[]" value="<?php echo $value['nomeProduto']; ?>">
                                </td>
                                <td>
                                    <?php echo $value['qtdProduto']; ?>
                                    <input type="hidden" name="qtd_produto[]" value="<?php echo $value['qtdProduto']; ?>">
                                </td>
                                <td>
                                    R$ <?php echo formatamoeda($value['valorProduto']); ?>
                                    <input type="hidden" name="valor_produto[]" value="<?php echo $value['valorProduto']; ?>">
                                </td>
                                <td class="text-right">
                                    R$ <?php echo formatamoeda($valorTotalItem); ?>
                                    <input type="hidden" name="valor_total[]" value="<?php echo $valorTotalItem; ?>">
                                </td>
                                <!-- <td><img src="assets/img/icons/delete.svg" alt="img" style="cursor: pointer;"  onclick="deleteItemListVendas(<?php echo $value['idItem']; ?>)"></td> -->
                            </tr>

                            <?php endforeach; ?>
                            <tr>
                                <td colspan="5"><strong style="font-size: 30px; color:brown">
                                    Total: <?php echo formatamoeda($subTotal); ?>
                                </strong></td>
                                <input type="hidden" value="<?php echo $subTotal; ?>" name="valorTotalInput" id="valorTotalInput">
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="row">

                <div class="col-sm=12">
                    <label class="label">Tipo de Venda</label>
                    <select class="form-control" name="formVenda" onchange="typeFormVendas()" id="typeFormVenda">
                        <option value="">SELECIONE UM TIPO DE VENDA</option>
                        <option value="Balcão">BALCÃO</option>
                        <option value="Mesa">MESA</option>
                        <option value="Delivery">DELIVERY</option>
                    </select>
                </div>

                    <div class="col-sm-6">
                        <label class="label">Selecione o tipo de pagamento</label>
                        <select class="form-control" name="formPagamento" disabled id="typeFormPg" onchange="fecharVenda()">
                            <option value="">SELECIONE UM TIPO DE PAGAMENTO</option>
                            <option value="Dinheiro">DINHEIRO</option>
                            <option value="Cartão">PIX</option>
                            <option value="Cartão">CARTÃO</option>
                            <option value="Prazo">A PRAZO</option>
                        </select>
                    </div>

                    <div class="col-sm-3">
                        <label class="label">Valor Pago:</label>
                        <input type="text" name="valorPago" disabled onkeyup="calcTroco()" id="valorPago" class="form-control" placeholder="0,00">
                    </div>

                    <div class="col-sm-3">
                        <label class="label">Troco:</label>
                        <input type="text" name="valorTroco" id="valorTroco" style="color: red; font-weight: bold;" class="form-control" disabled placeholder="0,00">
                    </div>

                    <div class="col-sm-6">
                        <label class="label">Mesa <span style="color: red; font-size:12px">Seleione uma mesa venda local</span></label>
                        <select class="form-control" id="inforMesas" onchange="contentMesas()" name="inforMesas" disabled>
                            <?php if(!empty($dataMesas)){
                                echo '<option value="">SELECIONE UMA MESA</option>';
                                foreach($dataMesas as $dataMesa):
                                    if($dataMesa['numero'] < 10){
                                        $numero = "0".$dataMesa['numero'];
                                    }else{
                                        $numero = $dataMesa['numero'];
                                    }
                            ?>
                                <option value="<?php echo $dataMesa['id']; ?>" style="text-transform: uppercase">MESA <?php echo $numero; ?></option>
                            <?php 
                                endforeach;
                                }else{
                                    echo '<option value="">Nenhuma mesa registrado</option>';
                                }
                            ?>
                        </select>
                    </div>

                    <div class="col-sm-6">
                        <label class="label">Cliente <span style="color: red; font-size:12px">Nome do cliente para mesa</span></label>
                        <input type="text" name="name_cliente" class="form-control" id="name_cliente" disabled>
                    </div>

                    <div class="col-sm-12">
                        <label class="label">Cliente <span style="color: red; font-size:12px">Selecione o cliente se for venda aprazo</span></label>
                        <select class="form-control" id="infoCliente" onchange="contentGetCliente()" name="inforCliente" disabled>
                            <?php if(!empty($dataCl)){
                                echo '<option value="">SELECIONE UM CLIENTE</option>';
                                foreach($dataCl as $dataCliente):
                            ?>
                                <option value="<?php echo $dataCliente['id_cliente']; ?>" style="text-transform: uppercase"><?php echo $dataCliente['nome_cliente']; ?></option>
                            <?php 
                                endforeach;
                                }else{
                                    echo '<option value="">Nenhum cliente registrado</option>';
                                }
                            ?>
                        </select>
                    </div>

                    <div class="col-sm-6" style="margin-top:2%">
                        <button class="btn btn-success" type="button" style="width: 100%; padding:20px;" onclick="addVenda()">FINALIZAR VENDA</button>
                    </div>

                    <div class="col-sm-6" style="margin-top:2%">
                        <button class="btn btn-danger" type="button" style="width: 100%; padding:20px;" onclick="closeModal()">CANCELAR</button>
                    </div>

                </div>

            </form>
            

        <?php
            }else{
            echo "erroNotSession";
        }
    }


    public function getListMesasPdv(){
        $u = new Users();
        $u->setLogged();
        $ms = new Mesas;
        $dataMesas = $ms->getListMesas($u->getIdCompany());
        if ($dataMesas) {
            foreach ($dataMesas as $dataMesa) :
                switch ($dataMesa['status_mesa']) {
                    case 'Ocupada':
                        $status = "Ocupada";
                        $type   = "#00B200";
                        $placa  = "";                        
                        $link   = "openModal('Finalizar Pedido', 'pedidos/finalizar/".$dataMesa['id']."')";
                    break;
                    case 'Reservada':
                        $status = "Reservada";
                        $type   = "#FF9F43";
                        $link   = "openModal('Confirma Reserva', 'pedidos/closereserva/".$dataMesa['id']."')";
                    break;
                    case 'Livre':
                        $status = "Livre";
                        $type   = "#F0F0F0";
                        $link   = "redirectMesaLivre(".$dataMesa['id'].")";
                    break;
                }
            ?>
                <div class="col-lg-2 col-sm-2 col-12">
                    <button class="btnMesasItems" style="background-color: <?php echo $type; ?>;" onclick="<?php echo $link; ?>">
                        <span class="placaInd" style="background-color: ;"><?php echo $status; ?></span>
                        <img src="assets/img/icons/mesas.png" alt="img">
                        <?php 
                            if(empty($dataMesa['nome_cliente'])){
                        ?>
                        <h6>MESA <?php if($dataMesa['numero'] < 10){ echo "0".$dataMesa['numero']; }else{echo $dataMesa['numero']; }; ?> </h6>
                        <?php } else {
                            echo '<h6>'.$dataMesa['nome_cliente'].'</h6>';
                        } ?>
                    </button>
                </div>
        <?php endforeach;
        } else {
            echo "Nenhuma mesa cadastrada";
        } 

    }


    public function openMesaPdv($idMesa){
        $data = array(
            "nameArq" => "pedidos",
            "namePag" => "Pedidos",
            "textPag" => "",
        );
        $u = new Users();
        $u->setLogged();

        $ct = new Categoria;

        $data['name_user'] = $u->getUserName();

        $data['getCatProd'] = $ct->getListAllCategory($u->getIdCompany());

        $data['idMesa'] = $idMesa;

        $this->loadTemplate('openPedidoMesa', $data);
    }

}




