<?php
class produtosController extends controller {

    public function __construct() {
        parent::__construct();

        $u = new Users();
        if($u->isLogged() == false) {
        	header("Location: ".BASE_URL."login");
        	exit;
        }
    }

    public function index() {
        $data = array(
            "nameArq" => "produtos",
            "namePag" => "Produtos",
            "textPag" => "",
        );
        $u = new Users();
        $u->setLogged();

        $data['idCompany'] = $u->getIdCompany();
        $data['name_user'] = $u->getUserName();

        $this->loadTemplate('produtos', $data);
    }

    public function add() {
        $data = array(
            "nameArq" => "produtos",
            "namePag" => "Produtos",
            "textPag" => "",
        );
        $u = new Users();
        $cat = new Categoria();
        $u->setLogged();

        $data['idCompany'] = $u->getIdCompany();
        $data['name_user'] = $u->getUserName();
        $data['dataCategory'] = $cat->getListAllCategory($u->getIdCompany());

        $this->loadTemplate('add_produto', $data);
    }


    public function actionAdd(){
        $data = array("msg");
        $function = new Functions();
        $prod = new Produto();

        $u = new Users();
        $u->setLogged();

        $name_produto       = filter_input(INPUT_POST, 'name_produto');
        $codigo_barra       = filter_input(INPUT_POST, 'codigo_barra');
        $ingredientes       = filter_input(INPUT_POST, 'ingrediente');
        $price_produto      = filter_input(INPUT_POST, 'price_produto');
        $unidade_medida     = filter_input(INPUT_POST, 'unidade_medida');
        $categoria          = filter_input(INPUT_POST, 'id_categoria');
        $status_produto     = filter_input(INPUT_POST, 'status_produto');

        if(empty($name_produto) || empty($price_produto) || empty($categoria) || empty($unidade_medida) || empty($status_produto)){
            $data['msg'] = "erroEmpty";
        }else{
            $nomeImage = "off.jpg";
            if(isset($_FILES['imagem_produto']['tmp_name']) && !empty($_FILES['imagem_produto']['tmp_name'])){
                $data['msg'] = $nomeImage = $function->uploadImagens($_FILES['imagem_produto'], 'fotos_produtos', 400, 400);                
            }

            $price_produto = str_replace(',', '.', $price_produto);

            if($prod->add($u->getIdCompany(), $name_produto, $price_produto, $unidade_medida, $ingredientes, $categoria, $nomeImage, $status_produto) === true){
                $data['msg'] = "sucesso";
            }else{
                $data['msg'] = "erroAdd";
            }
        }

        // if($function->uploadImagens($_FILES['imagem_produto'], "fotos_produtos", 400, 400)){
        //     $data['msg'] = "sucesso";
        // }else{
        //     $data['msg'] = "erroUpload";
        // }
        echo json_encode($data);
    }


    public function getListByIdProdutos($idProduto){
        $prod = new Produto();
        $u = new Users();
        $u->setLogged();
        $data = array("data");

        $data['data'] = $prod->getListByIdProduto($idProduto, $u->getIdCompany());

        echo json_encode($data);
    }


    public function listProdutoPdv(){
        //unset($_SESSION['getListVendas']);
        $prod = new Produto;
        $u = new Users();
        $u->setLogged();

        if(isset($_POST['idProd']) && isset($_POST['qtdItens'])){
            $dataProd = $prod->getListByIdProduto($_POST['idProd'], $u->getIdCompany());

           
            
            if(isset($_SESSION['getListVendas'][$_POST['idProd']])){
                $_SESSION['getListVendas'][$dataProd['id']]['qtdProduto']++; //$_POST['qtdItens'];
            }else{
                $_SESSION['getListVendas'][$_POST['idProd']] = array(
                    "idItem"        => $dataProd['id'],
                    "nomeProduto"   => $dataProd['nome'],
                    "qtdProduto"    => $_POST['qtdItens'],
                    "valorProduto"  => $dataProd['valor']
                );
            }
            
        };
        $subTotal = '0.00';
        //echo count($_SESSION['getListVendas']); exit;
        if(isset($_SESSION['getListVendas'])){

            

            foreach($_SESSION['getListVendas'] as $key => $value):
                $valorTotalItem = $value['valorProduto'] * $value['qtdProduto'];
                $subTotal += $valorTotalItem;
        ?>
        <tr>
            <td><?php echo $value['nomeProduto']; ?></td>
            <td><?php echo $value['qtdProduto']; ?></td>
            <td>R$ <?php echo formatamoeda($value['valorProduto']); ?></td>
            <td>R$ <?php echo formatamoeda($valorTotalItem); ?></td>
            <td><img src="assets/img/icons/delete.svg" alt="img" style="cursor: pointer;"  onclick="deleteItemListVendas(<?php echo $value['idItem']; ?>)"></td>
        </tr>
        <?php endforeach;

        ?>
             

            <?php
        }else{ ?> 
            <tr class="text-center text-primary"><td colspan="5">Nenhum produto listado</td></tr>';
        <?php } ?>
            <tr>
                <td colspan="5"><strong style="font-size: 30px;">Total: <?php echo formatamoeda($subTotal); ?></strong></td>
            </tr>
            <?php 

    }


    public function cancelarvendas(){
        unset($_SESSION['getListVendas']);
        if(!isset($_SESSION['getListVendas'])){
            echo "sucesso";
        }
    }


    public function deleteItemListVendas($idItem){
        if(isset($_SESSION['getListVendas'][$idItem])){
            unset($_SESSION['getListVendas'][$idItem]);
            echo "sucesso";
        }else{
            echo "erroNotExistItem";
        }
    }


    public function getListProdutos(){
        $u = new Users();
        $u->setLogged();
        //$u->getIdCompany();
        $prod = new Produto();
        $cat = new Categoria;

        if($prod->getListProdutos($u->getIdCompany())){
            foreach($prod->getListProdutos($u->getIdCompany()) as $dataProduto):
                $dataCategoria = $cat->getCategoriaById($u->getIdCompany(), $dataProduto['categoria']);
        ?>
            <tr>
                <td><strong><?php echo $dataProduto['nome']; ?></strong></td>
                <td class="text-center"><strong>R$ <?php echo !empty($dataProduto['valor']) ? formatamoeda($dataProduto['valor']) : "0,00"; ?></strong></td>
                <td class="text-center"><span class="badges bg-<?php echo $dataProduto['unidade_medida'] === "UND" ? "lightgreen" : "lightred"; ?>"><?php echo $dataProduto['unidade_medida'] === "UND" ? "UNIDADE" : "KG"; ?></span> </td>
                <td><?php echo $dataCategoria['nome']; ?></td>
                <td class="text-center"><a href="" class="btn btn-warning btn-sm" title="Cadastra Adicional" style="color:white;"><i class="fa-solid fa-plus"></i></a></td>
                <td class="text-center">
                    <a href="" class="btn btn-success btn-sm" title="Editar Produto" style="color: white;">
                        <i class="fa-regular fa-pen-to-square"></i></a>
                    <a href="" class="btn btn-danger btn-sm" title="Excluir Produto" style="color: white;"><i class="fa-solid fa-trash-can"></i></a></td>
            </tr>
        <?php 
            endforeach;
        }else{
            echo '<tr class="text-center text-danger"><td colspan="5">Nenhum produtos registrado</td></tr>';
        }
    }
    

}




