<?php

class Admin extends model {
    private $info;

    public function isLogged() {
		if(isset($_SESSION['users_erp']) && !empty($_SESSION['users_erp'])) {
			return true;
		} else {
			return false;
		}
    }

    public function getNameAdm() {
		if(isset($this->info['nome_adm'])) {
			return $this->info['nome_adm'];
		} else {
			return '';
		}
	}

    public function getId() {
		if(isset($this->info['id_adm'])) {
			return $this->info['id_adm'];
		} else {
			return '';
		}
	}

    public function doLogin($email_admin, $password_admin) {
		$sql = $this->db->prepare("SELECT * FROM tb_admin WHERE email_admin = :email_admin AND status_admin = :status_admin");
		$sql->bindValue(':email_admin', $email_admin);
		$sql->bindValue(':status_admin', "Aprovado");
		$sql->execute();
		if($sql->rowCount() > 0) {
			$row = $sql->fetch();

			if(password_verify($password_admin, $row['password_admin'])){
                $_SESSION['admin'] = $row['id_admin'];
                return $row['nome_admin'];
			}else{
                return false;
            }			
		} else {
			return false;
		}
    }

    public function getListAllAdmins() {
    	$array = array();
		$sql = $this->db->prepare("SELECT * FROM tb_admin");
		$sql->execute();
		if($sql->rowCount()>0){
			$array = $sql->fetchAll();
		}
		return $array;
    }
    
    public function setLoggedAdmin() {
		if(isset($_SESSION['admin']) && !empty($_SESSION['admin'])) {
			$id = $_SESSION['admin'];

			$sql = $this->db->prepare("SELECT * FROM tb_admin WHERE id_admin = :id");
			$sql->bindValue(':id', $id);
			$sql->execute();

			if($sql->rowCount() > 0) {
				$this->info = $sql->fetch();
			}
		}
    }

     public function logout() {
		unset($_SESSION['admin']);
	}

	public function verifyPassword($password) {
		$sql = $this->db->prepare("SELECT * FROM tb_admin WHERE id_admin = :id_admin");
		$sql->bindValue(':id_admin', $_SESSION['admin']);
		$sql->execute();
		if($sql->rowCount() > 0) {
			$row = $sql->fetch();
			if(password_verify($password, $row['password_admin'])){
                return true;
			}else{
                return false;
            }			
		} else {
			return false;
		}
    }
}