<?php

class Categoria extends model{

    public function getListAllCategory($idCompany){
        $array = array();
        $sql = $this->db->prepare("SELECT * FROM categorias WHERE idu = :idu");
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            $array = $sql->fetchAll();
        }
        return $array;
    }

    public function getCategoriaById($idCompany, $idCategoria){
        $sql= $this->db->prepare("SELECT * FROM categorias WHERE idu = :idu AND id = :idCategoria");
        $sql->bindvalue(":idu", $idCompany);
        $sql->bindValue(":idCategoria", $idCategoria);
        $sql->execute();
        if($sql->rowCount()>0){
            return $sql->fetch();
        }else{
            return "";
        }
    }


    public function add($idCompany, $name_categoria, $posicao_categoria, $nameImg){
        $sql = $this->db->prepare("INSERT INTO categorias SET nome = :nome, posicao = :posicao, url = :url, idu = :idu");
        $sql->bindValue(":nome", $name_categoria);
        $sql->bindValue(":posicao", $posicao_categoria);
        $sql->bindValue(":url", $nameImg);
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }

    public function edit($idCompany, $id_categoria, $name_categoria, $posicao_categoria, $nameImg){
        $sql = $this->db->prepare("UPDATE categorias SET
            nome    = :nome,
            posicao = :posicao,
            url     = :url
        WHERE idu = :idu AND id = :id_categoria");
        $sql->bindValue(":nome", $name_categoria);
        $sql->bindValue(":posicao", $posicao_categoria);
        $sql->bindValue(":url", $nameImg);
        $sql->bindValue(":id_categoria", $id_categoria);
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount() === 0){
            return false;
            exit;
        }
        return true;
    }

    public function getPositionCategory($idCompany, $posicao){
        $sql= $this->db->prepare("SELECT * FROM categorias WHERE idu = :idu AND posicao = :posicao");
        $sql->bindvalue(":idu", $idCompany);
        $sql->bindValue(":posicao", $posicao);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }

    public function getVerifyCategory($idCompany, $nome_categoria){
        $sql= $this->db->prepare("SELECT * FROM categorias WHERE idu = :idu AND nome = :nome");
        $sql->bindvalue(":idu", $idCompany);
        $sql->bindValue(":nome", $nome_categoria);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }

}