<?php

class Mesas extends model{

    public function getListMesas($idCompany){
        $sql = $this->db->prepare("SELECT * FROM mesas WHERE idu = :idu");
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            return $sql->fetchAll();
        }else{
            return array();
        }
    }


    public function add($idCompany, $numero_mesa){
        $sql = $this->db->prepare("INSERT INTO mesas SET
            numero      = :numero,
            idu         = :idu
        ");
        $sql->bindValue(":numero", $numero_mesa);
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            return true;
        }else{
            return false;
        }
    }

    public function edit($idCompany, $idMesa, $numero_mesa){
        $sql = $this->db->prepare("UPDATE mesas SET
            numero      = :numero
            WHERE id = :id AND idu = :idu
        ");
        $sql->bindValue(":numero", $numero_mesa);
        $sql->bindValue(":id", $idMesa);
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        return true;
    }


    public function getDatMesaById($idCompany, $idMesa){
        $sql = $this->db->prepare("SELECT * FROM mesas
            WHERE id = :id AND idu = :idu
        ");
        $sql->bindValue(":id", $idMesa);
        $sql->bindValue(":idu", $idCompany);
        $sql->execute();
        if($sql->rowCount()>0){
            return $sql->fetch();
        }else{
            return array();
        }
    }

}