<?php

class Users extends model {
    private $info;

    public function isLogged() {
		if(isset($_SESSION['pdvx']) && !empty($_SESSION['pdvx'])) {
			return true;
		} else {
			return false;
		}
    }

    public function getUserName() {
		if(isset($this->info['nome'])) {
			return $this->info['nome'];
		} else {
			return '';
		}
	}

    public function getIdCompany() {
        if(isset($this->info['idu'])) {
            return $this->info['idu'];
        } else {
            return '';
        }
    }

    public function getIdUser() {
        if(isset($this->info['id'])) {
            return $this->info['id'];
        } else {
            return '';
        }
    }

    public function getLevelAccess() {
        if(isset($this->info['level_admin'])) {
            return $this->info['level_admin'];
        } else {
            return '';
        }
    }


    public function doLogin($login_admin, $password_user) {
		$sql = $this->db->prepare("SELECT * FROM funcionarios WHERE login = :login AND acesso = :acesso");
		$sql->bindValue(':login', $login_admin);
		$sql->bindValue(':acesso', 1);
		$sql->execute();
		if($sql->rowCount() > 0) {
			$row = $sql->fetch();
			if(password_verify($password_user, $row['senha'])){
                $_SESSION['pdvx'] = $row['id'];
                return $row['nome'];
			}else{
                return false;
            }			
		} else {
			return false;
		}
    }

    public function setLogged() {
        if(isset($_SESSION['pdvx']) && !empty($_SESSION['pdvx'])) {
            $id = $_SESSION['pdvx'];

            $sql = $this->db->prepare("SELECT * FROM funcionarios WHERE id = :id");
            $sql->bindValue(':id', $id);
            $sql->execute();

            if($sql->rowCount() > 0) {
                $this->info = $sql->fetch();
            }
        }
    }


    public function verifyPasswordOpr($idUserOpr, $confirmPassword){
        $sql = $this->db->prepare("SELECT * FROM funcionarios WHERE id = :id");
        $sql->bindValue(":id", $idUserOpr);
        $sql->execute();
        if($sql->rowCount()>0){
            $row = $sql->fetch();
            if(password_verify($confirmPassword, $row['senha'])){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }

    public function logout() {
        unset($_SESSION['pdvx']);
    }

}