const menu = document.getElementById("menu");
const cartBtn = document.getElementById("cart-btn");
const cartModal = document.getElementById("myModal");
const cartItemContainer = document.getElementById("tbodyContainer");
const checkouBtn = document.getElementById("checkout-btn");
const closeModal = document.getElementById("close-modal-btn");
const titleModal = document.getElementById("title-modal");
const cartCount = document.getElementById("cart-count");
const spanTotal = document.getElementById("cart-total");
const formAddPedido = document.getElementById("formAddPedido");
const cart = [];
cartBtn.addEventListener("click", () => {
  if (cart.length == "") {
    notification(
      "ATENÇÃO!!!<br>",
      "Adicione itens ao seu pedido, para abri detalhes do pedido",
      "warning"
    );
    return;
  }
  updateCartModal();
  titleModal.innerHTML = "Detalhe Pedido";
  cartModal.style.display = "flex";
});

cartModal.addEventListener("click", (event) => {
  if (event.target === cartModal) {
    cartModal.style.display = "none";
  }
});

closeModal.addEventListener("click", () => {
  cartModal.style.display = "none";
});

menu.addEventListener("click", (event) => {
  let parentButton = event.target.closest(".add-to-cart-btn");

  if (parentButton) {
    const mesa = parentButton.getAttribute("data-mesa");
    const id = parentButton.getAttribute("data-id");
    const prod = parentButton.getAttribute("data-name");
    const price = parseFloat(parentButton.getAttribute("data-prace"));

    addToCart(mesa, id, prod, price);
  }
});

function addToCart(mesa, id, prod, price) {
  const existProditem = cart.find((item) => item.id === id);
  if (price) {
    if (existProditem) {
      if (confirm(prod + "adicionar mais um item ao produto?")) {
        existProditem.quantity += 1;
      }
    } else {
      cart.push({
        id,
        prod,
        price,
        quantity: 1,
        mesa,
      });
    }
    notification("SUCESSO!!!", "Produto adicionado com sucesso", "success");

    updateCartModal();
  }
}

function updateCartModal() {
  cartItemContainer.innerHTML = "";

  let total = 0;

  cart.forEach((item) => {
    const tr = document.createElement("tr");
    const cartItemElement = `
            <td>${item.prod}</td>
            <td class="py-1 text-center" width="80">
            ${item.quantity}
             <input type="hidden" name="idItem[]" value="${
               item.id
             }" id="idItem" />
            </td>
            <td class="py-1 text-center" width="80">
            R$ ${formataMoeda(item.price)}
            <input type="hidden" name="qtdItem[]" value="${
              item.quantity
            }" id="qtdItem" />
            </td>
            <td class="py-1 text-center" width="80">
            R$ ${formataMoeda(item.price * item.quantity)}
            <input type="hidden" name="totalValorItem[]" value="${
              item.price * item.quantity
            }" id="totalValorItem" />
            </td>
    `;
    tr.innerHTML = cartItemElement;
    total += item.price * item.quantity;
    cartItemContainer.appendChild(tr);
  });
  spanTotal.innerHTML = "R$ " + formataMoeda(total);
  document.getElementById("cart-total-taxa").innerHTML =
    "R$ " + formataMoeda(taxa);
  document.getElementById("inputTaxaU").value = taxa;
  document.getElementById("cart-sub-total").innerHTML =
    "R$ " + formataMoeda(total + taxa);
}

function formataMoeda(valor) {
  return valor.toLocaleString("pt-br", { minimumFractionDigits: 2 });
}

checkouBtn.addEventListener("click", async (event) => {
  event.preventDefault();
  const dataForm = new FormData(formAddPedido);

  const sendForm = await fetch("./addNewsPedido.php", {
    method: "POST",
    body: dataForm,
  });

  const response = await sendForm.json();
  
  console.log(response)

  if (response.result == "sucesso") {
    notification("SUCESSO!!!", "Pedido criado com sucesso", "success");
    cartModal.style.display = "none";
    setTimeout(function () {
      window.location.href = "garcom.php";
    }, 3000);
  } else {
    notification("ERROR!!!", "Erro no paramento de ids", "danger");
  }
});
